# GPU 및 시스템 냉각 상태 모니터링 대시보드

본 프로젝트는 Docker 기반으로 구축된 TIG 스택(InfluxDB, Grafana)을 활용하여 서버의 GPU 및 하드웨어 냉각 시스템의 상태를 실시간으로 모니터링하고, 이상 상황 발생 시 Slack으로 알림을 보내는 포괄적인 모니터링 솔루션입니다.

## 기술 아키텍처

시스템은 데이터 수집기(`gpu-monitor`), 시계열 데이터베이스(`influxdb`), 시각화 대시보드(`grafana`)의 세 가지 핵심 서비스로 구성됩니다.

-   **`gpu-monitor` (데이터 수집기)**:
    -   **역할**: 호스트 시스템의 하드웨어 센서 정보를 주기적으로 수집하여 InfluxDB에 저장하고, 이상 징후를 감지하여 Slack으로 알림을 보냅니다.
    -   **기반 기술**: `nvidia/cuda:12.1.0-base-ubuntu22.04` 이미지 위에 Python 3.10, `lm-sensors`, `i2c-tools` 등을 설치하여 구성됩니다. Python의 `schedule` 라이브러리를 통해 주기적인 모니터링 작업을 수행합니다.
    -   **데이터 소스**:
        -   `nvidia-smi` CLI: GPU 온도, 사용률, 메모리 등
        -   `lm-sensors`: CPU 코어 온도, 메인보드 전압 등
        -   `I2C bus` (`/dev/i2c-*`): 냉각수 온도, 유량 등 커스텀 센서 값
    -   **권한 설정**: 호스트의 하드웨어 장치 파일(`/dev/i2c-*`) 및 시스템 파일 시스템(`/sys/class/hwmon` 등)에 직접 접근하기 위해 `privileged: true` 권한과 `devices` 매핑이 설정되어 있습니다.

-   **`influxdb` (시계열 데이터베이스)**:
    -   **역할**: `gpu-monitor`가 수집한 모든 시계열 데이터(시간에 따른 온도, 팬 속도 변화 등)를 저장, 관리하고 Grafana의 쿼리에 응답합니다.
    -   **기반 기술**: `influxdb:2.7` 공식 이미지를 사용하며, 데이터는 `influxdb-data`라는 Docker 볼륨에 영속적으로 저장됩니다.

-   **`grafana` (시각화 대시보드)**:
    -   **역할**: InfluxDB에 저장된 데이터를 쿼리하여 사용자가 이해하기 쉬운 그래프, 게이지 등의 형태로 시각화합니다.
    -   **기반 기술**: `grafana/grafana:10.0.0` 공식 이미지를 사용합니다.
    -   **자동 프로비저닝**: `docker-compose.yml`의 볼륨 설정을 통해 `./grafana/provisioning` 디렉토리가 컨테이너에 마운트됩니다. 이 디렉토리에 데이터 소스(InfluxDB 연동 정보)와 대시보드(JSON 모델) 파일을 미리 정의해두면, Grafana 실행 시 자동으로 설정이 완료되어 수동 설정 과정이 필요 없습니다.

### 워크플로우

1.  **데이터 수집**: `gpu-monitor` 서비스의 Python 스크립트가 `schedule`에 따라 주기적으로 시스템 센서 값을 읽습니다.
2.  **데이터 저장**: 수집된 데이터는 InfluxDB로 전송되어 타임스탬프와 함께 저장됩니다.
3.  **시각화**: 사용자는 웹 브라우저로 Grafana 대시보드(`http://<서버_IP>:3000`)에 접속하여 실시간으로 변화하는 시스템 상태를 그래프로 확인합니다.
4.  **알림**: `gpu-monitor`가 미리 설정된 임계값(예: GPU 온도 85도 이상)을 초과하는 값을 감지하면, 즉시 Slack 채널로 경고 메시지를 보냅니다.

## 기술 스택

-   **오케스트레이션**: Docker, Docker Compose
-   **데이터베이스**: InfluxDB 2.7
-   **시각화**: Grafana 10.0.0
-   **데이터 수집기**: Python 3.10, `schedule`, `nvidia-ml-py3`, `smbus`
-   **시스템 도구**: `lm-sensors`, `i2c-tools`
-   **알림**: Slack (Webhook)

## 실행 방법

### 사전 요구사항

-   NVIDIA GPU가 장착된 호스트 시스템
-   호스트에 설치된 NVIDIA 드라이버 및 Docker, Docker Compose
-   NVIDIA Container Toolkit

### 설정

1.  프로젝트 루트 디렉토리에 `.env` 파일을 생성하고, `docker-compose.yml` 파일에 명시된 환경 변수들을 설정합니다. 최소한 아래 항목들은 필수로 설정해야 합니다.
    ```env
    # InfluxDB 설정
    INFLUXDB_USER=my-user
    INFLUXDB_PASSWORD=my-password
    INFLUXDB_ORG=my-org
    INFLUXDB_BUCKET=my-bucket
    INFLUXDB_TOKEN=my-super-secret-token

    # Grafana 관리자 계정
    GRAFANA_ADMIN_USER=admin
    GRAFANA_ADMIN_PASSWORD=admin

    # Slack 알림 웹훅 URL
    SLACK_WEBHOOK_URL=https://hooks.slack.com/services/T00000000/B00000000/XXXXXXXXXXXXXXXXXXXXXXXX
    ```

### 실행

1.  **Docker 서비스 시작**:
    ```bash
    docker-compose up -d
    ```

2.  **애플리케이션 접근**:
    -   **Grafana 대시보드**: `http://<서버_IP>:3000`
    -   **InfluxDB UI**: `http://<서버_IP>:8086`

### 중지

```bash
docker-compose down
``` 