# VNEXA ABB API 프로젝트 사용자 가이드

## 목차
1. [Cursor 규칙](#cursor-규칙)
2. [질문 방법](#질문-방법)
3. [에러 해결 요청](#에러-해결-요청)
4. [코드 리뷰 요청](#코드-리뷰-요청)
5. [기능 구현 요청](#기능-구현-요청)
6. [문서화 요청](#문서화-요청)
7. [최적화 요청](#최적화-요청)
8. [효과적인 사용을 위한 팁](#효과적인-사용을-위한-팁)

## Cursor 규칙

### 개요
Cursor 규칙은 프로젝트의 일관성과 품질을 유지하기 위한 가이드라인입니다. 다음과 같은 세 가지 수준의 규칙이 있습니다:

1. **.cursorrules**: 프로젝트 전체에 적용되는 기본 규칙
   - 모든 대화는 한국어로 진행
   - 코드 스타일 가이드
   - 디버깅 규칙
   - 문서화 요구사항
   - 보안 및 성능 가이드라인

2. **Project Rules**: 특정 파일이나 디렉토리에 적용되는 규칙
   - 파일별 특수 규칙
   - 디렉토리별 가이드라인
   - 특정 기능 구현 규칙

3. **Global Rules**: 모든 프로젝트에 공통으로 적용되는 규칙
   - 기본 작업 방식
   - 코딩 표준
   - API 설계 원칙
   - 배포 규칙

### 규칙 사용 방법

1. **기본 규칙 준수**
   - 모든 코드 작성 시 .cursorrules에 명시된 스타일 가이드 준수
   - 디버그 로그는 [DEBUG] 접두사 사용
   - 테스트 로그는 [TEST] 접두사 사용
   - 성능 관련 로그는 [PERF] 접두사 사용

2. **파일별 규칙 적용**
   - 특정 파일 타입에 대한 규칙은 자동으로 적용
   - 새로운 파일 생성 시 관련 규칙 확인
   - 규칙 위반 시 자동으로 경고 표시

3. **규칙 커스터마이징**
   - .cursorrules 파일 수정으로 기본 규칙 변경 가능
   - Project Rules 추가로 특정 파일/디렉토리 규칙 설정
   - Global Rules는 시스템 관리자만 수정 가능

4. **규칙 확인 방법**
   - 파일 편집 시 우측 패널에서 적용된 규칙 확인
   - 규칙 위반 시 자동으로 하이라이트 표시
   - 규칙 설명은 마우스 오버로 확인 가능

## 질문 방법

### 나쁜 예시
```
❌ "코드 어떻게 짜야 해?"
❌ "에러 왜 나는 거야?"
❌ "이거 어떻게 해?"
```

### 좋은 예시
```
✅ "FastAPI로 사용자 인증 API를 구현해주세요:
- 입력: 이메일, 비밀번호
- 출력: JWT 토큰
- 요구사항: 비밀번호 해싱, 토큰 만료시간 24시간"
```

## 에러 해결 요청

### 나쁜 예시
```
❌ "에러가 나요"
❌ "이거 안돼요"
```

### 좋은 예시
```
✅ "다음 에러가 발생했습니다:
- 에러 메시지: [에러 메시지]
- 발생 상황: [구체적인 상황]
- 관련 코드: [코드 스니펫]
- 시도한 해결 방법: [이미 시도한 방법들]"
```

## 코드 리뷰 요청

### 나쁜 예시
```
❌ "이 코드 봐줘"
❌ "개선해줘"
```

### 좋은 예시
```
✅ "다음 코드의 성능을 개선해주세요:
- 현재 코드: [코드 스니펫]
- 개선 목표: [구체적인 목표]
- 제약사항: [유지해야 할 기능]
- 성능 요구사항: [구체적인 수치]"
```

## 기능 구현 요청

### 나쁜 예시
```
❌ "로그인 기능 만들어줘"
❌ "데이터 처리해줘"
```

### 좋은 예시
```
✅ "다음 기능을 구현해주세요:
- 목적: [구체적인 목적]
- 입력 데이터: [데이터 형식과 예시]
- 처리 요구사항: [구체적인 처리 방법]
- 출력 형식: [원하는 출력 형식]
- 성능 요구사항: [처리 시간, 메모리 사용 등]"
```

## 문서화 요청

### 나쁜 예시
```
❌ "문서 작성해줘"
❌ "API 문서 만들어줘"
```

### 좋은 예시
```
✅ "다음 API에 대한 문서를 작성해주세요:
- API 엔드포인트: [엔드포인트 정보]
- 요청/응답 형식: [데이터 구조]
- 인증 방식: [인증 방법]
- 사용 예시: [구체적인 사용 사례]
- 특별 고려사항: [보안, 성능 등]"
```

## 최적화 요청

### 나쁜 예시
```
❌ "느려요"
❌ "빠르게 해줘"
```

### 좋은 예시
```
✅ "다음 코드의 성능을 개선해주세요:
- 현재 코드: [코드 스니펫]
- 성능 문제: [구체적인 문제점]
- 목표 성능: [구체적인 수치]
- 제약사항: [유지해야 할 기능]
- 현재 실행 시간: [측정된 시간]"
```

## 효과적인 사용을 위한 팁

### 1. 구체적인 컨텍스트 제공
- 문제의 배경과 목적을 명확히 설명
- 관련된 코드나 에러 메시지 포함
- 이미 시도한 해결 방법 언급

### 2. 단계적 접근
- 복잡한 요청은 작은 단위로 나누어 요청
- 각 단계별로 피드백 받기
- 점진적으로 기능 확장

### 3. 피드백 활용
- 제안된 해결책에 대한 의견 제공
- 추가 요구사항 명확히 전달
- 문제 해결 과정에서 발생하는 새로운 이슈 공유

### 4. 문서화 활용
- todo.md를 통한 작업 진행 상황 관리
- 중요한 결정사항 기록
- 문제 해결 과정 문서화

## 주의사항
1. 모든 요청은 구체적이고 명확하게 작성
2. 필요한 컨텍스트 정보는 누락하지 않기
3. 이미 시도한 방법이나 해결책이 있다면 언급
4. 요구사항이나 제약사항을 명확히 전달
5. 피드백을 통해 지속적으로 개선

## 참고사항
- 이 가이드는 프로젝트의 효율적인 진행을 위한 참고 자료입니다
- 필요에 따라 가이드 내용이 업데이트될 수 있습니다
- 특별한 요구사항이나 제약사항이 있는 경우 별도로 언급해주세요 