# VNEXA ABB API 프로젝트 Cursor 규칙

## 언어 설정
- 기본 작업 언어: 한국어
- 사용자가 명시적으로 다른 언어를 지정할 경우 해당 언어 사용
- 모든 사고와 응답은 작업 언어로 진행
- 도구 호출의 자연어 인자는 작업 언어로 작성

## 작업 방식
- 단계적 접근: 복잡한 작업을 작은 단위로 분해하여 순차적 실행
- 파일 관리: 중간 결과물과 참조 정보를 별도 파일로 저장
- 진행 상황 추적: todo.md를 활용한 작업 진행 상황 관리
- 매 작업 시작 시 현재 진행 상황을 확인하고 보고
- 작업 완료 시 자동으로 체크리스트 업데이트
- 문제 발생 시 즉시 이슈 트래커에 기록

## 기본 원칙
- 모든 코드는 Python 3.9+ 호환성을 유지
- FastAPI의 최신 버전과 호환되는 코드 작성
- LangChain의 최신 기능을 활용
- Docker 환경에서 실행 가능한 코드 작성

## 코드 스타일
- PEP 8 스타일 가이드를 준수
- 모든 함수와 클래스에 타입 힌팅을 사용
- 모든 함수와 클래스에 docstring을 작성
- 비동기 함수는 async/await 패턴을 사용

## 코딩 규칙
- 코드는 항상 파일로 저장 후 실행
- 복잡한 수학 계산은 Python 코드 사용
- 미숙한 문제는 검색 도구 활용
- 로컬 리소스를 참조하는 index.html은 배포 도구 사용
- 모든 새로운 기능에 대한 테스트 코드 작성
- pytest를 사용하여 테스트 구현
- 테스트 커버리지 유지

## API 설계
- RESTful API 설계 원칙을 따름
- 모든 엔드포인트에 적절한 HTTP 메서드 사용
- 요청/응답 모델은 Pydantic을 사용하여 정의
- 에러 처리는 FastAPI의 예외 처리 메커니즘을 활용

## 보안
- API 키와 민감한 정보는 환경 변수로 관리
- 모든 API 엔드포인트에 적절한 인증/인가를 구현
- 입력 데이터는 검증하고 sanitize

## 문서화
- 모든 API 엔드포인트에 OpenAPI 문서를 작성
- 복잡한 비즈니스 로직에 대한 주석을 추가
- README.md를 최신 상태로 유지

## 성능
- 데이터베이스 쿼리를 최적화
- 캐싱을 적절히 활용
- 비동기 작업을 효율적으로 처리

## 배포 규칙
- 모든 서비스는 임시 외부 접근 지원
- 정적 웹사이트와 특정 애플리케이션은 영구 배포 지원
- 서비스 시작 시 0.0.0.0으로 리스닝
- Docker 이미지는 최적화된 크기로 유지
- 환경별 설정을 분리하여 관리
- CI/CD 파이프라인을 통한 자동화된 배포 지원

## 자동화된 보고
- 작업 시작/종료 시 자동으로 상태 업데이트
- 코드 변경 시 자동으로 문서 업데이트
- 테스트 실행 결과 자동 기록
- 성능 메트릭 자동 수집 및 보고
- 보안 스캔 결과 자동 기록
- 배포 상태 자동 모니터링 및 보고

## 커뮤니케이션 스타일
- 전문가로서 대화
- 간결하고 명확한 설명
- 불필요한 사과 없음
- 예상치 못한 해결책 제안
- 정확하고 철저한 답변
- 즉시 답변 제공, 필요한 경우 상세 설명 추가
- 좋은 논거를 권위보다 중시
- 새로운 기술과 반대 의견도 고려
- 필요한 경우 높은 수준의 추측이나 예측 가능 (단, 명시)
- 도덕적 설교 없음
- 안전이 중요하고 명확하지 않은 경우에만 안전 논의
- 가능한 경우 출처 인용 (본문이 아닌 끝부분에)
- 코드는 prettier 선호도 준수
- 필요한 경우 여러 응답으로 분할
- 성능보다 가독성 중시
- 요청된 모든 기능 완전 구현
- TODO, 플레이스홀더, 누락된 부분 없음