# 클린 코드 원칙

클린 코드란 팀의 모든 구성원이 쉽게 이해할 수 있는 코드입니다. 클린 코드는 원래 작성자가 아닌 다른 개발자도 읽고 개선할 수 있습니다. 이해력이 향상되면 가독성, 변경 가능성, 확장성 및 유지 관리성이 함께 향상됩니다.

## 일반 규칙
1. 표준 규칙을 따르세요.
2. 단순하게 유지하세요. 더 단순한 것이 항상 더 좋습니다. 복잡성을 최대한 줄이세요.
3. 보이스카우트 규칙을 따르세요. 발견했을 때보다 더 깨끗하게 캠프장을 떠나세요.
4. 항상 근본 원인을 찾으세요. 항상 문제의 근본 원인을 찾으세요.

## 설계 규칙
1. 구성 가능한 데이터를 높은 수준에 유지하세요.
2. if/else 또는 switch/case보다 다형성을 선호하세요.
3. 멀티스레딩 코드를 분리하세요.
4. 과도한 구성 가능성을 방지하세요.
5. 의존성 주입을 사용하세요.
6. 디미터의 법칙을 따르세요. 클래스는 직접적인 의존성만 알아야 합니다.

## 이해 가능성 팁
1. 일관성을 유지하세요. 특정 방식으로 작업을 수행한다면 유사한 모든 작업을 동일한 방식으로 수행하세요.
2. 설명적인 변수를 사용하세요.
3. 경계 조건을 캡슐화하세요. 경계 조건은 추적하기 어렵습니다. 이러한 처리를 한 곳에 모으세요.
4. 기본 타입보다 전용 값 객체를 선호하세요.
5. 논리적 의존성을 피하세요. 같은 클래스 내의 다른 것에 의존하여 올바르게 작동하는 메서드를 작성하지 마세요.
6. 부정적인 조건을 피하세요.

## 이름 규칙
1. 설명적이고 명확한 이름을 선택하세요.
2. 의미 있는 구별을 만드세요.
3. 발음 가능한 이름을 사용하세요.
4. 검색 가능한 이름을 사용하세요.
5. 매직 넘버를 명명된 상수로 대체하세요.
6. 인코딩을 피하세요. 접두사나 타입 정보를 추가하지 마세요.

## 함수 규칙
1. 작게 유지하세요.
2. 한 가지 일만 하세요.
3. 설명적인 이름을 사용하세요.
4. 인수를 적게 사용하세요.
5. 부작용이 없어야 합니다.
6. 플래그 인수를 사용하지 마세요. 메서드를 클라이언트가 플래그 없이 호출할 수 있는 여러 독립적인 메서드로 분할하세요.

## 주석 규칙
1. 항상 코드로 자신을 설명하려고 노력하세요.
2. 중복되지 않게 하세요.
3. 명백한 노이즈를 추가하지 마세요.
4. 닫는 중괄호 주석을 사용하지 마세요.
5. 코드를 주석 처리하지 마세요. 그냥 제거하세요.
6. 의도 설명으로 사용하세요.
7. 코드 명확화로 사용하세요.
8. 결과에 대한 경고로 사용하세요.

## 소스 코드 구조
1. 개념을 수직으로 분리하세요.
2. 관련 코드는 수직으로 밀집되어 나타나야 합니다.
3. 변수를 사용하는 위치와 가깝게 선언하세요.
4. 의존적인 함수는 가까이 있어야 합니다.
5. 유사한 함수는 가까이 있어야 합니다.
6. 함수를 내림차순으로 배치하세요.
7. 줄을 짧게 유지하세요.
8. 수평 정렬을 사용하지 마세요.
9. 관련된 것들을 연결하고 약하게 관련된 것들을 분리하기 위해 공백을 사용하세요.
10. 들여쓰기를 깨뜨리지 마세요.

## 객체 및 데이터 구조
1. 내부 구조를 숨기세요.
2. 데이터 구조를 선호하세요.
3. 하이브리드 구조(반은 객체, 반은 데이터)를 피하세요.
4. 작아야 합니다.
5. 한 가지 일만 해야 합니다.
6. 인스턴스 변수 수가 적어야 합니다.
7. 기본 클래스는 파생 클래스에 대해 아무것도 알지 않아야 합니다.
8. 행동을 선택하기 위해 일부 코드를 함수에 전달하는 것보다 많은 함수를 갖는 것이 좋습니다.
9. 정적 메서드보다 비정적 메서드를 선호하세요.

## 테스트
1. 테스트당 하나의 어설션만 하세요.
2. 읽기 쉬워야 합니다.
3. 빨라야 합니다.
4. 독립적이어야 합니다.
5. 반복 가능해야 합니다.

## 코드 냄새
1. 경직성. 소프트웨어를 변경하기 어렵습니다. 작은 변경으로 인해 후속 변경 사항이 연쇄적으로 발생합니다.
2. 취약성. 소프트웨어가 하나의 변경으로 인해 여러 위치에서 손상됩니다.
3. 부동성. 관련된 위험과 높은 노력으로 인해 코드 일부를 다른 프로젝트에서 재사용할 수 없습니다.
4. 불필요한 복잡성.
5. 불필요한 반복.
6. 불투명성. 코드를 이해하기 어렵습니다. 