# **통합 Docker 환경 리포트**

## **📝 개요**

본 문서는 사내에서 운영 중인 주요 서버들의 Docker 환경 정보를 통합하여 제공합니다. 각 서버별 Docker 버전, 시스템 정보, 스토리지 드라이버, 네트워크 설정, 및 Docker Compose 프로젝트의 포트 설정을 요약하여 Docker 환경 관리 및 문제 해결에 도움을 드리고자 합니다.

## **🐳 서버별 Docker 버전 현황**

| 서버 이름 | Docker Engine 버전 (Client) | Docker Engine 버전 (Server) | API 버전 (Client) | API 버전 (Server) | Go 버전 (Client) | Go 버전 (Server) | Git Commit (Client) | Git Commit (Server) | Built Date (Client) | Built Date (Server) | OS/Arch | containerd 버전 | runc 버전 | docker-init 버전 |
| :---- | :---- | :---- | :---- | :---- | :---- | :---- | :---- | :---- | :---- | :---- | :---- | :---- | :---- | :---- |
| **gds-PowerEdge-R760xa** | 28.0.4 | 28.0.4 | 1.48 | 1.48 | go1.23.7 | go1.23.7 | b8034c0 | 6430e49 | Mar 25 2025 | Mar 25 2025 | linux/amd64 | 1.7.27 | N/A\[^1\] | 0.19.0 |
| **gds-PowerEdge-R820** | 27.3.1 | 27.3.1 | 1.47 | 1.47 | go1.22.7 | go1.22.7 | ce12230 | 41ca978 | Sep 20 2024 | Sep 20 2024 | linux/amd64 | 1.7.22 | 1.1.14 | 0.19.0 |
| **gds-PowerEdge-R820-2** | 27.1.1 | 27.1.1 | 1.46 | 1.46 | go1.21.12 | go1.21.12 | 6312585 | cc13f95 | Jul 23 2024 | Jul 23 2024 | linux/amd64 | 1.7.19 | 1.7.19 | 0.19.0 |
| **desktopserver** | 27.0.3 | 27.0.3 | 1.46 | 1.46 | go1.21.11 | go1.21.11 | 7d4bcd8 | 662f78c | Jun 29 2024 | Jun 29 2024 | linux/amd64 | 1.7.18 | 1.7.18 | 0.19.0 |
| **gds-PT620** | 20.10.11 | 26.0.2 | 1.41 | 1.45 | go1.16.9 | go1.21.9 | dea9396 | 7cef0d9 | Nov 18 2021 | Apr 18 2024 | linux/amd64 | 1.6.31 | 1.1.12 | 0.19.0 |
| **gds** | 24.0.7 | 24.0.7 | 1.43 | 1.43 | go1.20.10 | go1.20.10 | afdd53b | 311b9ff | Oct 26 2023 | Oct 26 2023 | linux/amd64 | 1.6.26 | 1.1.10 | 0.19.0 |

\[^1\]: gds-PowerEdge-R760xa의 runc 버전은 nvidia 필드로 대체되어 있어, 일반적인 runc 버전 정보가 직접적으로 표시되지 않습니다.

## **⚙️ 공통 Docker 시스템 정보**

대부분의 서버에서 다음과 같은 공통적인 Docker 시스템 정보를 확인했습니다.

* **Debug Mode**: false  
* **Plugins**:  
  * buildx: Docker Buildx (Docker Inc.)  
  * scan: Docker Scan (Docker Inc.) (gds-PT620 제외)

## **💾 스토리지 드라이버 현황**

| 서버 이름 | 스토리지 드라이버 | 데이터 공간 (총) | 데이터 공간 (사용 중) | 데이터 공간 (사용 가능) | 백본 파일시스템 |
| :---- | :---- | :---- | :---- | :---- | :---- |
| **gds-PowerEdge-R760xa** | overlay2 | 3.129TB | 20.35GB | 3.109TB | xfs |
| **gds-PowerEdge-R820** | overlay2 | 472.0GB | 15.01GB | 456.9GB | xfs |
| **gds-PowerEdge-R820-2** | overlay2 | 472.0GB | 11.23GB | 460.8GB | xfs |
| **desktopserver** | overlay2 | 472.0GB | 2.977GB | 469.0GB | xfs |
| **gds-PT620** | overlay2 | 99.27GB | 21.05GB | 78.22GB | xfs |
| **gds** | overlay2 | 9.873TB | 2.213TB | 7.66TB | extfs |

* **참고**: overlay2 드라이버는 대부분의 서버에서 사용되고 있으며, 이는 Docker의 권장 스토리지 드라이버입니다. Data Space 및 Metadata Space 정보는 overlay2 드라이버 특성상 별도로 표시되지 않거나 백본 파일시스템의 정보를 따릅니다.

## **🌐 네트워크 구성 현황**

### **bridge 네트워크**

모든 서버에서 기본 bridge 네트워크가 활성화되어 있으며, 주로 172.17.0.0/16 서브넷을 사용합니다. gds-PowerEdge-R760xa 서버는 추가적으로 172.22.0.0/16 서브넷을 사용하는 vnexa-abb-api\_default 브릿지 네트워크를 가지고 있습니다.

| 서버 이름 | 네트워크 이름 | Scope | Driver | IPv6 활성화 | Subnet | Gateway | Attachable |
| :---- | :---- | :---- | :---- | :---- | :---- | :---- | :---- |
| **gds-PowerEdge-R760xa** | bridge | local | bridge | false | 172.22.0.0/16 | 172.22.0.1 | true |
|  | vnexa-abb-api\_default | local | bridge | false | 172.22.0.0/16 | 172.22.0.1 | true |
| **gds-PowerEdge-R820** | bridge | local | bridge | false | 172.17.0.0/16 | 172.17.0.1 | true |
| **gds-PowerEdge-R820-2** | bridge | local | bridge | false | 172.17.0.0/16 | 172.17.0.1 | true |
| **desktopserver** | bridge | local | bridge | false | 172.17.0.0/16 | 172.17.0.1 | true |
| **gds-PT620** | bridge | local | bridge | false | 172.17.0.0/16 | 172.17.0.1 | true |
| **gds** | bridge | local | bridge | false | 172.17.0.0/16 | 172.17.0.1 | true |

### **host 네트워크**

모든 서버에서 host 네트워크가 존재하며, 이는 Docker 컨테이너가 호스트의 네트워크 스택을 직접 사용하도록 합니다.

### **none 네트워크**

모든 서버에서 none 네트워크가 존재하며, 이는 컨테이너에 네트워크 인터페이스를 연결하지 않아 외부와의 통신을 차단합니다.

## **📦 Docker Compose 프로젝트 및 포트 매핑 현황**

제공된 docker ps 정보를 기반으로 각 서버에서 실행 중인 Docker Compose 프로젝트와 해당 컨테이너의 포트 매핑을 정리했습니다. "호스트 포트 \-\> 컨테이너 포트" 형식으로 표기합니다.

### **gds-PowerEdge-R760xa**

| Docker Compose 프로젝트 | 컨테이너 이름 | 포트 매핑 (Host \-\> Container) |
| :---- | :---- | :---- |
| vnexa-abb-api | vnexa-abb-api\_api\_1 | 8000/tcp \-\> 8000/tcp |
| rvtouch3d-api | rvtouch3d-api\_frontend\_1 | 3002/tcp \-\> 3000/tcp |
| rvtouch3d-api | rvtouch3d-api\_grafana\_1 | 3003/tcp \-\> 3000/tcp |
| rvtouch3d-api | rvtouch3d-api\_app\_1 | 8001/tcp \-\> 8000/tcp |
| rvtouch3d-api | rvtouch3d-api\_prometheus\_1 | 9092/tcp \-\> 9090/tcp |
| rvtouch3d-api | rvtouch3d-api\_postgres\_1 | 5434/tcp \-\> 5432/tcp |
| rvtouch3d-api | rvtouch3d-api\_redis\_1 | 6381/tcp \-\> 6379/tcp |
| jupyter\_gpu\_docker | jupyter-gpu | 8888/tcp \-\> 8888/tcp |

### **gds-PowerEdge-R820**

| Docker Compose 프로젝트 | 컨테이너 이름 | 포트 매핑 (Host \-\> Container) |
| :---- | :---- | :---- |
| docker\_3dp | docker\_3dp | 80-\>80/tcp, 3000-\>3000/tcp, 3306-\>3306/tcp, 8080-\>8080/tcp, 8090-\>8090/tcp, 2212-\>22/tcp |
| docker\_vnexa\_api | docker\_vnexa\_api | 2213-\>22/tcp, 3001-\>3000/tcp |
| docker\_metaverse | docker\_nodam | 52530-\>52530/tcp, 52532-52533-\>52532-52533/tcp, 53306-\>53306/tcp, 2236-\>22/tcp |
| (추정) ubuntu-ssh | ubuntu-ssh | 52530-\>52530/tcp, 52532-52533-\>52532-52533/tcp, 53306-\>53306/tcp, 2236-\>22/tcp (이 컨테이너는 Exited 상태입니다.) |

### **gds-PowerEdge-R820-2**

| Docker Compose 프로젝트 | 컨테이너 이름 | 포트 매핑 (Host \-\> Container) |
| :---- | :---- | :---- |
| docker\_java | docker\_java | 2233-\>22/tcp, 4446-\>443/tcp, 33064-\>3306/tcp, 8092-\>8080/tcp |

### **desktopserver**

| Docker Compose 프로젝트 | 컨테이너 이름 | 포트 매핑 (Host \-\> Container) |
| :---- | :---- | :---- |
| docker\_centos | docker\_geumdo | 2230-\>22/tcp, 8091-\>80/tcp, 4445-\>443/tcp, 33063-\>3306/tcp (IPv4 및 IPv6 바인딩 포함) |

### **gds-PT620**

| Docker Compose 프로젝트 | 컨테이너 이름 | 포트 매핑 (Host \-\> Container) |
| :---- | :---- | :---- |
| docker\_posivibes | docker\_posivibes | 2240/tcp \-\> 22/tcp, 8084/tcp \-\> 8080/tcp |
| docker\_db | docker\_db\_server\_1 | 9011/tcp \-\> 9011/tcp, 9013/tcp \-\> 9013/tcp, 2228/tcp \-\> 22/tcp, 33062/tcp \-\> 3306/tcp |
| docker\_gitlab | docker\_gitlab\_web\_1 | 2224/tcp \-\> 22/tcp, 8081/tcp \-\> 80/tcp, 4430/tcp \-\> 443/tcp |
| (추정) docker\_all | docker\_all | 3690/tcp \-\> 3690/tcp, 9908/tcp \-\> 9908/tcp, 2226/tcp \-\> 22/tcp, 8086/tcp \-\> 80/tcp, 33060/tcp \-\> 3306/tcp, 8083/tcp \-\> 8080/tcp |

### **gds**

| Docker Compose 프로젝트 | 컨테이너 이름 | 포트 매핑 (Host \-\> Container) |
| :---- | :---- | :---- |
| docker\_fastapi | fastapi\_server | 8000/tcp \-\> 8000/tcp |
| docker\_fastapi\_new | fastapi\_new\_server | 8001/tcp \-\> 8001/tcp |
| docker\_db | docker\_db\_server\_1 | 2113/tcp \-\> 22/tcp, 33066/tcp \-\> 3306/tcp |
| docker\_was\_upgrade\_http | docker\_was\_upgrade\_http | 2237/tcp \-\> 22/tcp, 4446/tcp \-\> 443/tcp, 8093/tcp \-\> 8080/tcp |
| docker\_flask\_proxy | docker\_flask\_proxy | 3001/tcp \-\> 3000/tcp |
| docker\_securedb | docker\_dbsec | 8090/tcp \-\> 8090/tcp, 9908/tcp \-\> 9908/tcp, 2234/tcp \-\> 22/tcp |
| docker\_jupyter | docker\_jupyter\_server\_1 | 8888/tcp \-\> 8888/tcp, 2115/tcp \-\> 22/tcp |
| docker\_open\_webui | open-webui | 9000/tcp \-\> 8080/tcp (plus 11434/tcp internal) |
| (독립 컨테이너) | ollama | 11434/tcp \-\> 11434/tcp |
| docker\_was\_upgrade | docker\_was\_upgrade | 2116/tcp \-\> 22/tcp, 4444/tcp \-\> 443/tcp, 8088/tcp \-\> 8080/tcp |
| (독립 컨테이너) | poste-io | 25/tcp \-\> 25/tcp, 110/tcp \-\> 110/tcp, 143/tcp \-\> 143/tcp, 465/tcp \-\> 465/tcp, 587/tcp \-\> 587/tcp, 993/tcp \-\> 993/tcp, 995/tcp \-\> 995/tcp, 4190/tcp \-\> 4190/tcp, 8800/tcp \-\> 80/tcp, 4433/tcp \-\> 443/tcp |
| docker\_was | docker\_was | 8080/tcp \-\> 8080/tcp, 2114/tcp \-\> 22/tcp, 4333/tcp \-\> 443/tcp (plus 4333/tcp internal) |

* **참고**: docker-compose.project 라벨이 없는 컨테이너의 경우, 컨테이너 이름 또는 이미지 이름에서 프로젝트를 추정했습니다. 포트 매핑은 호스트에 노출된 포트와 컨테이너 내부 포트를 의미합니다.

## **📝 특이사항 및 권고사항**

* **Docker 버전 관리**: 서버별로 Docker Engine 버전이 다양합니다. 최신 기능 활용 및 보안 강화를 위해 가능한 한 최신 안정 버전으로 업데이트하는 것을 고려해볼 수 있습니다. 특히 gds-PT620은 Client와 Server의 Docker 버전이 다른 점에 유의해야 합니다.  
* **API 버전**: 대부분의 서버가 1.46 이상의 API 버전을 사용하고 있어 최신 Docker CLI 기능을 활용할 수 있습니다.  
* **스토리지 드라이버**: 모든 서버가 overlay2를 사용하여 효율적인 이미지 및 컨테이너 관리가 가능합니다.  
* **네트워크 관리**: gds-PowerEdge-R760xa에서 추가적인 브릿지 네트워크(vnexa-abb-api\_default)가 사용되는 것을 확인했습니다. 특정 서비스에 대한 네트워크 분리가 필요한 경우 유용하게 활용될 수 있습니다.  
* **포트 관리**: 각 Docker Compose 프로젝트 및 개별 컨테이너에서 사용하는 포트들이 다양하게 외부에 노출되어 있습니다. 불필요하게 외부에 노출된 포트가 없는지 정기적으로 검토하여 보안을 강화하는 것이 좋습니다.