# Java(Maven) 프로젝트 Docker화 예제/템플릿

이 프로젝트는 Spring Boot 등 내장 WAS를 사용하는 Java Maven 프로젝트를 Docker 컨테이너로 만드는 방법을 보여주는 예제 또는 템플릿입니다. 사용자가 자신의 Maven 프로젝트에 맞게 수정하여 사용하는 것을 전제로 합니다.

## 주요 기능

- **기반 환경**: Ubuntu 20.04, OpenJDK 17, Maven
- **빌드 및 실행 스크립트**: Maven 프로젝트를 빌드(`mvn clean package`)하고, 생성된 JAR/WAR 파일을 실행/중지/재시작하는 쉘 스크립트(`start_service.sh`)를 제공합니다.
- **소스 코드 마운트**: 호스트의 `./data` 디렉토리를 컨테이너의 `/data`에 마운트하여 소스 코드를 쉽게 다룰 수 있습니다.
- **원격 접속**: OpenSSH Server

## 이 템플릿의 동작 원리

1.  `Dockerfile`은 OpenJDK 17과 Maven이 설치된 Ubuntu 환경을 구성합니다.
2.  `docker-compose.yml`은 로컬의 `./data` 폴더를 컨테이너의 `/data`로 마운트합니다. **사용자는 이 `./data` 폴더에 자신의 Maven 프로젝트를 위치시켜야 합니다.**
3.  컨테이너 내부의 `/service_script/start_service.sh`는 `/data/webapps/{프로젝트명}` 경로에 있는 Maven 프로젝트를 빌드하고 실행하는 기능을 담고 있습니다.

**주의**: 현재 설정 그대로는 컨테이너가 시작된 후 아무 동작도 하지 않고 바로 종료됩니다. `start_service.sh`가 특정 동작(예: `build`, `start`)을 수행하도록 `Dockerfile`의 `CMD` 부분을 수정하거나, 컨테이너에 접속하여 수동으로 스크립트를 실행해야 합니다.

## 사용 방법

### 1. 소스 코드 준비

이 프로젝트의 루트에 `data` 폴더를 만들고, 그 안에 `webapps` 폴더를, 또 그 안에 자신의 Maven 프로젝트(pom.xml이 있는)를 위치시킵니다.

```
.
├── data/
│   └── webapps/
│       └── <내_메이븐_프로젝트>/
│           ├── src/
│           └── pom.xml
├── Dockerfile
├── docker-compose.yml
└── ...
```

### 2. (수정) 실행 스크립트 맞춤화

`/service_script/start_service.sh` 스크립트 상단의 변수들을 자신의 프로젝트에 맞게 수정해야 합니다.

- `DEFAULT_APP_NAME`: `<내_메이븐_프로젝트>` 이름으로 변경
- `DEFAULT_WAR_PATH`: 빌드 후 생성되는 JAR/WAR 파일의 경로로 수정
- ... 등

### 3. (수정) Dockerfile CMD 수정

컨테이너가 시작될 때 자동으로 빌드 및 실행을 하도록 `Dockerfile`의 마지막 줄을 수정합니다.

**예시**:
```dockerfile
# 기존 CMD
# CMD ["/service_script/start_service.sh"]

# 변경된 CMD (빌드 후 시작)
CMD ["/bin/bash", "-c", "/service_script/start_service.sh build && /service_script/start_service.sh start && tail -f /dev/null"]
```

### 4. 빌드 및 시작

수정이 완료되면, 아래 스크립트를 사용하여 이미지를 빌드하고 컨테이너를 시작합니다.
```bash
./rebuild_docker.sh
```

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 설명 |
|---|---|---|---|
| SSH | `2213` | `22` | `ssh root@<서버_IP> -p 2213` (root/!@#gds$%^) |
| App Port 1 | `8080` | `8080`| (애플리케이션에서 사용하는 포트) |
| App Port 2 | `8090` | `8090`| (애플리케이션에서 사용하는 포트) | 