# 업그레이드된 Java WAS 환경 (Tomcat 9 / OpenJDK 11)

이 프로젝트는 OpenJDK 11과 Tomcat 9를 기반으로 하는 현대적인 Java 웹 애플리케이션 서버(WAS) 환경을 Docker를 사용하여 구축합니다.

## 주요 기능

- **기반 환경**: Ubuntu 20.04
- **Java**: OpenJDK 11
- **웹 애플리케이션 서버(WAS)**: Apache Tomcat 9.0.96
- **원격 접속**: OpenSSH Server
- **데이터 영속성**: Tomcat 설정과 웹 애플리케이션 데이터는 Docker 볼륨을 통해 영속적으로 관리됩니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

### 1. 서비스 시작 및 빌드

아래 스크립트를 실행하여 Docker 볼륨을 생성하고, 이미지를 빌드한 뒤, 컨테이너를 시작합니다.

```bash
./rebuild_docker.sh
```

이 스크립트는 다음 작업을 자동으로 수행합니다:
1.  Tomcat 설정(`wasconfig_upgrade_http`)과 데이터(`wardata_upgrade_http`)를 저장할 Docker 볼륨을 확인하고 없는 경우 생성합니다.
2.  `Dockerfile`을 기반으로 이미지를 빌드합니다.
3.  `docker-compose.yml` 설정을 사용하여 컨테이너를 백그라운드에서 실행합니다.

### 2. 웹 애플리케이션 배포

이 환경은 WAS만 제공하므로, 실행할 웹 애플리케이션(WAR 파일)을 직접 배포해야 합니다. `wardata_upgrade_http` 볼륨이 호스트의 특정 디렉토리와 연결되어 있지 않으므로, `docker cp` 명령어를 사용하는 것이 일반적입니다.

```bash
# 1. 로컬에 있는 WAR 파일을 실행 중인 컨테이너의 Tomcat 웹앱 디렉토리로 복사
# 예: my_app.war 파일을 배포하는 경우
docker cp my_app.war docker_was_upgrade_http:/usr/local/tomcat/webapps/

# 2. 또는, 데이터 볼륨으로 지정된 /data 디렉토리에 복사
docker cp my_app.war docker_was_upgrade_http:/data/
```
배포 방식은 사용하는 웹 애플리케이션의 특성에 맞게 선택합니다.

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2237` | `22` | `ssh root@<서버_IP> -p 2237` | `root` | `!@#gds$%^` |
| Tomcat (HTTP) | `8093` | `8080` | `http://<서버_IP>:8093` | - | - |
| Tomcat (HTTPS)| `4446` | `443`  | `https://<서버_IP>:4446` | - | - |

**참고**: HTTPS를 사용하려면, `wasconfig_upgrade_http` 볼륨에 마운트된 Tomcat 설정 디렉토리(`/usr/local/tomcat/conf`)의 `server.xml` 파일을 수정하고 SSL 인증서 파일을 해당 볼륨에 추가하는 등의 별도 설정이 필요합니다. 