# Java WAS 환경 (Tomcat 8.5 / OpenJDK 8) for sabg.war

이 프로젝트는 `sabg.war`라는 특정 Java 웹 애플리케이션을 배포하고 실행하기 위한 Docker 환경입니다. Ubuntu 20.04 위에 OpenJDK 8과 Tomcat 8.5.28을 기반으로 구축되었습니다.

## 주요 기능

- **기반 환경**: Ubuntu 20.04
- **Java**: OpenJDK 8
- **웹 애플리케이션 서버(WAS)**: Apache Tomcat 8.5.28
- **원격 접속**: OpenSSH Server
- **데이터 영속성**: Tomcat 설정과 애플리케이션 데이터는 Docker 볼륨을 통해 영속적으로 관리됩니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

### 1. 서비스 시작 및 빌드

아래 스크립트를 실행하여 Docker 볼륨을 생성하고, 이미지를 빌드한 뒤, 컨테이너를 시작합니다.

```bash
./rebuild_docker.sh
```

이 스크립트는 `wasconfig`와 `wardata` 볼륨을 생성하고 `docker-compose.yml` 설정에 따라 컨테이너를 백그라운드에서 실행합니다.

### 2. `sabg.war` 배포 (수동)

컨테이너가 실행된 후, 프로젝트 루트에 있는 `sabg.war` 파일을 Tomcat의 배포 디렉토리로 복사해야 합니다.

```bash
# docker_was는 docker-compose.yml에 정의된 컨테이너 이름입니다.
docker cp sabg.war docker_was:/usr/local/tomcat/webapps/
```
파일 복사가 완료되면 Tomcat이 자동으로 애플리케이션을 인식하고 배포를 시작합니다.

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2114` | `22` | `ssh root@<서버_IP> -p 2114` | `root` | `!@#gds$%^` |
| Tomcat (HTTP)| `8080` | `8080` | `http://<서버_IP>:8080/sabg` | - | - |
| Tomcat (HTTPS)|`4333` | `443`  | `https://<서버_IP>:4333/sabg` | - | - |

**참고**:
- 위 Tomcat 주소의 `/sabg`는 `sabg.war` 파일이 배포될 때의 컨텍스트 경로 예시이며, 실제 경로는 다를 수 있습니다.
- HTTPS를 사용하려면 `wasconfig` 볼륨 내의 Tomcat `server.xml`을 수정하고 SSL 인증서를 추가하는 별도 설정이 필요합니다. 