from flask import Flask, Response
import random

app = Flask(__name__)

# 샘플 Markdown 데이터 리스트
markdown_samples = [
    """# 제목
## 부제목
일반적인 텍스트입니다.
- 리스트 항목 1
- 리스트 항목 2

---

### 인용문
> 이것은 인용문입니다.

---

### 코드 블록
```python
def greet():
    return "Hello, Markdown!"
```
""",
    """# Python 코드 예제
```python
def hello():
    print("Hello, World!")
```

---

### 수식 표현
$E = mc^2$
""",
    """# 테이블 예제
| 이름 | 나이 | 직업 |
|------|----|-----|
| 홍길동 | 30 | 개발자 |
| 김철수 | 28 | 디자이너 |

---

### 체크리스트
- [x] 할 일 1
- [ ] 할 일 2
""",
    """# 복합 문서 예제
## 개요
이 문서는 다양한 마크다운 기능을 포함하고 있습니다.

### 목록
1. 첫 번째 항목
2. 두 번째 항목
3. 세 번째 항목

### 강조
**굵게**, *기울임*, ~~취소선~~

### 링크
[Google](https://www.google.com)

### 이미지
![Markdown Logo](https://markdown-here.com/img/icon256.png)
"""
]

@app.route('/markdown')
def get_markdown():
    markdown_content = random.choice(markdown_samples)
    return Response(markdown_content, mimetype='text/markdown')

if __name__ == '__main__':
    app.run(host='0.0.0.0', port=3000, debug=True)
