# 기본 Flask API 서버 예제 (Ubuntu + SSH)

본 프로젝트는 Docker를 사용하여 간단한 Flask API 서버를 구축하는 기본적인 예제입니다. SSH 원격 접속이 가능한 Ubuntu 20.04 환경 위에, 특정 API를 호출하면 미리 정의된 마크다운(Markdown) 텍스트를 무작위로 반환하는 Flask 애플리케이션을 실행합니다.

## 기술 아키텍처

-   **`Dockerfile`**: `ubuntu:20.04` 공식 이미지를 기반으로 다음 환경을 구성합니다.
    -   **시스템 패키지**: `openssh-server`, `python3`, `python3-pip` 등 서버 운영과 Python 개발에 필요한 최소한의 도구를 설치합니다.
    -   **애플리케이션 코드**: 호스트의 `app` 디렉토리를 컨테이너의 `/app`으로 복사합니다.
    -   **Python 의존성**: `app/requirements.txt` 파일에 명시된 `flask` 라이브러리를 설치합니다.
    -   **실행**: 컨테이너 시작 시 `CMD ["python3", "app.py"]` 명령을 통해 Flask 내장 개발 서버를 직접 실행합니다.

-   **`docker-compose.yml`**:
    -   `Dockerfile`을 빌드하여 `docker_vnexa_api`라는 이름의 컨테이너를 생성합니다.
    -   **포트 매핑**:
        -   호스트의 `2213`번 포트를 컨테이너의 `22`번(SSH) 포트로 연결합니다.
        -   호스트의 `3001`번 포트를 컨테이너의 `3000`번(Flask API) 포트로 연결합니다.
    -   **실시간 동기화**: `volumes` 설정을 통해 호스트의 `./app` 디렉토리를 컨테이너의 `/app`으로 마운트합니다. 이를 통해 호스트에서 코드를 수정하면 별도의 빌드 과정 없이 컨테이너에 즉시 반영되어 개발 편의성을 높입니다. (단, 서버 재시작은 필요할 수 있음)

## API 명세

-   **엔드포인트**: `GET /markdown`
-   **설명**: API 호출 시, 서버에 미리 정의된 여러 개의 샘플 마크다운 텍스트 중 하나를 무작위로 선택하여 반환합니다.
-   **응답 형식**: `text/markdown`

## 주요 특징

-   **단순성**: Flask 프레임워크와 Docker를 연동하는 가장 기본적인 구조를 보여주어, Python 기반 웹 개발 입문자나 테스트 환경 구축에 적합합니다.
-   **개발 편의성**: 코드 수정 시 컨테이너를 다시 빌드할 필요 없이 실시간으로 변경 사항이 반영되는 개발 환경을 제공합니다.
-   **기본적인 원격 관리**: SSH 접속 기능을 포함하여, 컨테이너 내부에 직접 들어가 상태를 확인하거나 패키지를 설치하는 등 원격 관리가 가능합니다.

## 실행 방법

### 사전 요구사항

-   Docker 및 Docker Compose

### 실행

1.  **Docker 이미지 빌드 및 컨테이너 실행**:
    ```bash
    # (선택) 재빌드 및 실행 스크립트
    ./rebuild_docker.sh

    # 또는 docker-compose 직접 실행
    docker-compose up --build -d
    ```

2.  **API 테스트**:
    -   컨테이너 실행 후, 웹 브라우저나 `curl` 명령어를 사용하여 API를 테스트할 수 있습니다.
    ```bash
    curl http://localhost:3001/markdown
    ```

3.  **SSH 접속**:
    -   `root` 계정으로 컨테이너에 원격 접속합니다.
    ```bash
    ssh root@<서버_IP> -p 2213
    ```
    -   비밀번호는 `Dockerfile`에 설정된 `root` 사용자의 비밀번호(`!@#gds$%^`)를 입력합니다.

### 중지

```bash
docker-compose down
``` 