# 기본 Ubuntu 22.04 + SSH 서버 환경

본 프로젝트는 Docker를 사용하여 SSH 원격 접속이 가능한 기본 Ubuntu 22.04 서버 환경을 구축합니다. `sudo` 권한을 가진 일반 사용자가 사전에 설정되어 있어, 다양한 용도의 베이스 이미지로 활용하기에 적합합니다.

## 기술 아키텍처

-   **`Dockerfile`**: `ubuntu:22.04` 공식 이미지를 기반으로 다음과 같은 설정을 수행합니다.
    -   **패키지 설치**: `openssh-server`, `vim`, `net-tools`, `sudo` 등 기본적인 서버 관리 도구를 설치합니다.
    -   **사용자 계정 설정**:
        -   `root` 계정의 비밀번호를 설정합니다.
        -   `gds`라는 이름의 새로운 일반 사용자를 생성하고, `sudo` 그룹에 추가하여 관리자 권한을 부여합니다.
    -   **SSH 서버 구성**:
        -   컨테이너 시작 시 `/usr/sbin/sshd -D` 명령어를 실행하여 SSH 데몬을 포그라운드 모드로 구동합니다.
        -   `/etc/ssh/sshd_config` 파일에 `AllowUsers gds` 설정을 추가하여, 명시적으로 `gds` 사용자에게만 SSH 원격 접속을 허용합니다. (보안 강화 조치)

-   **`docker-compose.yml`**:
    -   `Dockerfile`을 빌드하여 `ubuntu-ssh`라는 이름의 컨테이너를 생성합니다.
    -   **포트 매핑**: 호스트의 `2236`번 포트를 컨테이너의 `22`번(SSH) 포트로 연결하여 외부에서의 원격 접속을 가능하게 합니다.
    -   `52530`(Nginx), `52532`(Node.js) 등 다른 서비스 포트들도 함께 매핑하고 있으나, 실제 서비스는 설치되어 있지 않습니다. 이는 본 이미지를 기반으로 다른 서비스를 확장할 것을 염두에 둔 설계입니다.

## 주요 특징

-   **보안성**: `root`의 직접적인 SSH 접속을 막고 `sudo` 권한을 가진 일반 사용자를 통해서만 시스템에 접근하도록 하여 기본적인 서버 보안을 준수합니다.
-   **단순성**: 특정 애플리케이션에 종속되지 않은 순수한 Ubuntu + SSH 환경을 제공하여, 사용자가 원하는 어떤 소프트웨어든 자유롭게 설치하고 구성할 수 있습니다.
-   **확장성**: 다양한 애플리케이션이 사용할 표준 포트들을 미리 노출(expose)하고 매핑(port-mapping)하여, 이 이미지를 베이스로 삼아 웹 서버, 데이터베이스 서버 등 복잡한 환경을 손쉽게 구축할 수 있습니다.

## 실행 방법

### 사전 요구사항

-   Docker 및 Docker Compose

### 실행

1.  **Docker 이미지 빌드 및 컨테이너 실행**:
    ```bash
    # (선택) 재빌드 및 실행 스크립트
    ./rebuild_docker.sh

    # 또는 docker-compose 직접 실행
    docker-compose up --build -d
    ```

2.  **SSH 접속**:
    -   컨테이너가 실행된 후, 로컬 터미널이나 SSH 클라이언트를 사용하여 다음 명령어로 접속합니다.
    ```bash
    ssh gds@<서버_IP> -p 2236
    ```
    -   비밀번호는 `Dockerfile`에 설정된 `gds` 사용자의 비밀번호 (`gds12!@`)를 입력합니다.

### 중지

```bash
docker-compose down
``` 