# DBSEC 보안 솔루션 실행 환경

이 프로젝트는 'DBSEC'으로 추정되는 특정 데이터베이스 보안 솔루션을 실행하기 위한 Docker 환경을 제공합니다. Ubuntu 20.04와 OpenJDK 11을 기반으로 하며, 솔루션 데이터는 영속적인 Docker 볼륨에 저장됩니다.

## 주요 기능

- **실행 환경**: Ubuntu 20.04, OpenJDK 11
- **원격 접속**: OpenSSH Server
- **데이터 영속성**: 솔루션의 모든 데이터와 실행 파일은 `dbsec_whole_data` Docker 볼륨 내의 `/securedb` 디렉토리에 저장되어 컨테이너의 생명주기와 관계없이 보존됩니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)
- **DBSEC 솔루션 파일**: 이 환경은 솔루션 자체를 포함하고 있지 않습니다. 사전에 `dbsec_whole_data` 라는 Docker 볼륨의 `/securedb` 경로에 DBSEC 솔루션이 설치되어 있어야 합니다.

## 사용 방법

### 1. (최초 설정) DBSEC 솔루션 준비

이 Docker 환경을 사용하기 전에, `dbsec_whole_data` 볼륨을 생성하고 그 안에 솔루션 파일을 위치시켜야 합니다.

만약 기존에 사용하던 `dbsec_whole_data` 볼륨이 없다면, `rebuild_docker.sh` 스크립트가 빈 볼륨을 생성해줍니다. 이 경우, 컨테이너 실행 후 `docker cp` 명령 등을 사용하여 `/securedb` 디렉토리에 솔루션 파일을 복사하고 설치/설정을 진행해야 합니다.

### 2. 서비스 시작 및 빌드

아래 스크립트를 실행하여 Docker 이미지를 빌드하고 컨테이너를 시작합니다.

```bash
./rebuild_docker.sh
```

이 스크립트는 `dbsec_whole_data` 볼륨을 확인(없으면 생성)하고, `docker-compose.yml` 설정에 따라 컨테이너를 백그라운드에서 실행합니다.

### 3. 솔루션 실행

컨테이너는 SSH 서비스만 자동으로 시작합니다. DBSEC 솔루션의 데몬이나 서비스는 컨테이너에 접속하여 직접 실행해야 합니다.

```bash
# 컨테이너 접속
ssh root@<서버_IP> -p 2234

# /securedb 디렉토리로 이동하여 솔루션 실행 스크립트 실행
cd /securedb
./start_dbsec.sh  # (실제 실행 스크립트 이름은 다를 수 있음)
```

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2234` | `22` | `ssh root@<서버_IP> -p 2234` | `root` | `!@#gds$%^` |
| DBSEC Tomcat | `8090` | `8090` | `http://<서버_IP>:8090` | - | - |
| DBSEC Connect |`9908` | `9908`| (솔루션 전용 접속 포트) | - | - |

**참고**: 위 포트 정보는 `docker-compose.yml`에 명시된 내용이며, 실제 서비스가 해당 포트에서 동작하려면 `/securedb` 내부의 솔루션이 정상적으로 실행되어야 합니다. 