# Docker 사설 레지스트리 (Web UI 포함)

이 프로젝트는 Docker Compose를 사용하여 Docker 이미지를 저장하고 관리할 수 있는 사설 레지스트리를 구축합니다. 이미지 관리를 위한 웹 UI가 함께 제공됩니다.

## 주요 기능

- **Docker Registry**: Docker 공식 `registry:2` 이미지를 사용하여 안정적인 이미지 저장소를 제공합니다.
- **Web UI**: `joxit/docker-registry-ui` 이미지를 사용하여 웹 브라우저에서 레지스트리의 이미지를 확인하고 관리(삭제 등)할 수 있는 편리한 UI를 제공합니다.
- **데이터 영속성**: 푸시된 모든 Docker 이미지는 호스트의 `./registry/data` 디렉토리에 저장되어 영속적으로 보존됩니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

### 1. (필수) 환경 설정 수정

`docker-compose.yml` 파일을 열어 `registry-ui` 서비스의 환경 변수를 **반드시 수정해야 합니다.**

```yaml
// ...
services:
  registry-ui:
    // ...
    environment:
     // ...
     # 아래 두 줄의 IP 주소를 현재 서버의 IP 주소 또는 도메인으로 변경하세요.
     - NGINX_PROXY_PASS_URL=http://<YOUR_SERVER_IP>:5001
     - REGISTRY_URL=http://<YOUR_SERVER_IP>:5001
// ...
```

### 2. 서비스 시작

아래 명령어를 실행하여 레지스트리와 UI 컨테이너를 시작합니다.

```bash
docker-compose up -d
```
명령을 실행하면 현재 디렉토리에 `registry/data` 폴더가 자동으로 생성됩니다.

### 3. 레지스트리 사용

**a. 이미지 태그 지정**

로컬의 Docker 이미지를 사설 레지스트리에 푸시하려면, `호스트주소:포트` 형식으로 태그를 지정해야 합니다.

```bash
# 예시: my-image:latest 이미지를 레지스트리에 맞게 태그 지정
docker tag my-image:latest <YOUR_SERVER_IP>:5001/my-image:latest
```

**b. 이미지 푸시**

태그가 지정된 이미지를 레지스트리로 푸시합니다.

```bash
docker push <YOUR_SERVER_IP>:5001/my-image:latest
```
**참고**: HTTP 레지스트리에 푸시하려면, Docker 데몬 설정에 `insecure-registries` 옵션을 추가해야 할 수 있습니다. (`/etc/docker/daemon.json` 파일에 `"insecure-registries" : ["<YOUR_SERVER_IP>:5001"]` 추가 후 Docker 재시작)

**c. 이미지 풀**
```bash
docker pull <YOUR_SERVER_IP>:5001/my-image:latest
```

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 설명 |
|---|---|---|---|
| Registry UI | `8085` | `80` | `http://<YOUR_SERVER_IP>:8085` (웹 관리 UI) |
| Registry API| `5001` | `5000` | `docker push/pull` 에 사용되는 주소 | 