# Java WAS 환경 (Tomcat 8.5 / OpenJDK 8) - Posivibes

이 프로젝트는 "Posivibes"로 명명된 Java 웹 애플리케이션을 실행하기 위한 Docker 기반의 웹 애플리케이션 서버(WAS) 환경입니다. Ubuntu 20.04 위에 OpenJDK 8과 Tomcat 8.5.98이 설치됩니다.

## 주요 기능

- **기반 환경**: Ubuntu 20.04
- **Java**: OpenJDK 8, Maven
- **웹 애플리케이션 서버(WAS)**: Apache Tomcat 8.5.98
- **원격 접속**: OpenSSH Server
- **데이터 영속성**: Tomcat 설정, 데이터, 웹 애플리케이션(WAR) 파일이 모두 Docker 볼륨을 통해 영속적으로 관리됩니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

### 1. 서비스 시작 및 빌드

아래 스크립트를 실행하여 Docker 볼륨을 생성하고, 이미지를 빌드한 뒤, 컨테이너를 시작합니다.

```bash
./rebuild_docker.sh
```

이 스크립트는 `wasconfig_posivibes`, `data_posivibes`, `wardata_posivibes` 3개의 볼륨을 생성하고 `docker-compose.yml` 설정에 따라 컨테이너를 백그라운드에서 실행합니다.

### 2. 웹 애플리케이션 배포

이 환경은 Tomcat의 `webapps` 디렉토리를 `wardata_posivibes` 라는 Docker 볼륨과 직접 연결합니다. 따라서 애플리케이션(WAR 파일)을 배포하려면 이 볼륨에 파일을 복사해야 합니다.

가장 간단한 방법은 실행 중인 컨테이너를 통해 `docker cp` 명령을 사용하는 것입니다.

```bash
# 로컬의 my_app.war 파일을 컨테이너의 /usr/local/tomcat/webapps/ 경로로 복사
# 이 경로는 wardata_posivibes 볼륨과 연결되어 있음
docker cp my_app.war docker_posivibes:/usr/local/tomcat/webapps/
```
복사가 완료되면 Tomcat이 자동으로 애플리케이션을 배포합니다.

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2240` | `22` | `ssh root@<서버_IP> -p 2240` | `root` | `!@#gds$%^` |
| Tomcat (HTTP)| `8084` | `8080` | `http://<서버_IP>:8084` | - | - |

**참고**: `docker-compose.yml`에는 `/data` 디렉토리에 마운트되는 `data_posivibes` 볼륨도 정의되어 있습니다. 애플리케이션이 데이터를 저장하는 용도로 사용할 수 있습니다. 