# Nginx 리버스 프록시 및 Let's Encrypt SSL/TLS 관리 서버

본 프로젝트는 Docker를 사용하여 Nginx 기반의 리버스 프록시 서버를 구축하고, Let's Encrypt의 `certbot`을 통해 SSL/TLS 인증서를 발급 및 관리하는 환경을 제공합니다. 여러 웹 애플리케이션의 트래픽을 단일 진입점에서 처리하고, 안전한 HTTPS 통신을 적용하는 데 사용됩니다.

## 기술 아키텍처

시스템은 모든 기능이 포함된 단일 Docker 컨테이너로 구성되어 있으며, 모든 중요 설정과 데이터는 호스트 머신에 볼륨으로 마운트하여 관리하는 Stateless 아키텍처를 따릅니다.

-   **`Dockerfile`**: `ubuntu:20.04` 베이스 이미지 위에 다음의 핵심 소프트웨어를 설치합니다.
    -   `nginx`: 메인 리버스 프록시 서버.
    -   `openssh-server`: 원격 관리를 위한 SSH 서버.
    -   `certbot` & `python3-certbot-nginx`: Let's Encrypt의 공식 클라이언트와 Nginx 설정을 자동으로 수정해주는 Certbot 플러그인.

-   **`docker-compose.yml`**:
    -   **단일 서비스 `os`**: `Dockerfile`을 빌드하여 `nginx_proxy`라는 이름의 컨테이너를 생성합니다.
    -   **포트 매핑**: 웹 트래픽의 표준 포트인 `80`(HTTP), `443`(HTTPS)과 원격 관리를 위한 `22`(SSH) 포트를 호스트와 직접 연결합니다.
    -   **볼륨 마운트 (핵심)**:
        -   `./nginx.conf`: Nginx의 메인 설정 파일.
        -   `./sites-available`, `./sites-enabled`: 가상 호스트(Server Block) 설정 디렉토리.
        -   `./letsencrypt`: `certbot`이 생성하는 계정 정보, 인증서, 갱신 설정 등 모든 데이터.
        -   `./ssl`, `./ssl-certs`: Nginx가 사용할 SSL 인증서 파일.
        -   이 구조를 통해 컨테이너는 상태 없이(stateless) 실행 환경만 제공하며, 모든 설정과 데이터는 호스트에서 영속적으로 관리됩니다.

-   **`start_service.sh`**: 컨테이너 시작 시 SSH 서버와 Nginx를 백그라운드로 실행하고, 컨테이너가 종료되지 않도록 대기하는 단순한 구조입니다.

## 주요 기능 및 운영 방식

-   **리버스 프록시**: HTTP/HTTPS 요청을 수신하여, `sites-available`에 설정된 도메인 규칙에 따라 내부망의 다른 웹 애플리케이션으로 요청을 전달(Proxy Pass)합니다.
-   **SSL 인증서 발급**: `certbot` CLI를 사용하여 Let's Encrypt로부터 SSL 인증서를 발급받습니다. `python3-certbot-nginx` 플러그인을 통해 Nginx 설정을 자동으로 수정하여 HTTPS를 적용할 수 있습니다.
    ```bash
    # 컨테이너 접속
    docker exec -it nginx_proxy /bin/bash

    # Certbot 실행 (예시)
    certbot --nginx -d example.com -d www.example.com
    ```
-   **SSL 인증서 갱신**:
    -   **주의**: 현재 설정에는 **인증서 자동 갱신 로직이 포함되어 있지 않습니다.**
    -   Let's Encrypt 인증서는 90일마다 만료되므로, 관리자가 주기적으로 컨테이너에 접속하여 아래 명령어를 실행하거나, 호스트 시스템에 별도의 cron 작업을 설정하여 자동화를 구성해야 합니다.
    ```bash
    # 건식 실행 (실제 갱신 없이 테스트)
    certbot renew --dry-run

    # 실제 갱신
    certbot renew
    ```

## 실행 방법

### 사전 요구사항

-   Docker 및 Docker Compose
-   프록시할 도메인 및 해당 도메인이 서버의 공인 IP를 가리키도록 설정된 DNS 레코드.

### 실행

1.  **초기 설정**:
    -   `sites-available` 디렉토리에 프록시할 서버 블록 파일을 생성합니다. (최초 인증서 발급을 위해 80번 포트에 대한 서버 블록이 필요합니다.)
2.  **컨테이너 실행**:
    ```bash
    # (선택) 재빌드 및 실행 스크립트
    ./rebuild_docker.sh

    # 또는 docker-compose 직접 실행
    docker-compose up --build -d
    ```
3.  **인증서 발급 및 적용**:
    -   위의 "주요 기능 및 운영 방식" 섹션을 참고하여 컨테이너에 접속한 뒤 `certbot` 명령어를 실행합니다.

### 중지

```bash
docker-compose down
``` 