#!/bin/bash

# SSH 서버 시작
/usr/sbin/sshd -D & sleep 5

# php-fpm (Nginx 전에 시작)
service php7.2-fpm start && sleep 5

# nginx
ln -s /etc/nginx/sites-available/default /etc/nginx/sites-enabled
service nginx start && sleep 5

# mysql
usermod -d /var/lib/mysql mysql
service mysql start && sleep 5

# MySQL 서버가 시작될 때까지 대기
until mysqladmin ping -h localhost --silent; do
    echo 'MySQL이 시작될 때까지 대기 중...'
    sleep 3
done

# 루트 비밀번호 설정
mysql -u root --skip-password -e "ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY '1q2w3e4r5t';"
# SQL 파일 적용
mysql -u root -p1q2w3e4r5t < /service_script/nodam.sql

# node module install
cd /home/ubuntu/node || exit 1 && sleep 5
npm install && sleep 5

# node
node index.js &
sleep 5
node socket.js &
wait

# Service 재시작 시 Docker가 종료되지 않도록 대기
tail -f /dev/null
