#!/bin/sh
# Build Docker image with explicit build context and Dockerfile path
# Check and create volumes if they don't exist
create_volume() {
    docker volume inspect $1 > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        echo "Volume '$1' already exists."
    else
        docker volume create --name=$1
        echo "Volume '$1' created."
    fi
}

create_volume nodam_dbdata
create_volume nodam_dbconfig

docker build -t .

# Run Docker Compose with a specific container name
docker-compose up -d --build
