# PHP & Node.js 하이브리드 애플리케이션 서버 (노담)

본 프로젝트는 Docker를 사용하여 '노담(Nodam)'으로 추정되는 PHP 및 Node.js 기반의 복합 웹 애플리케이션 서버 환경 전체를 패키징한 것입니다. 기존 서버의 파일 구조, 데이터베이스, 실행 환경을 그대로 Docker 컨테이너로 마이그레이션하여, `docker-compose up` 명령어 하나로 전체 시스템을 구동할 수 있도록 설계되었습니다.

## 기술 아키텍처

시스템은 Nginx, PHP-FPM, Node.js, MySQL 등 모든 구성요소가 단일 Docker 컨테이너에서 동작하는 올인원(All-in-one) 방식으로 구축되었습니다.

-   **`Dockerfile`**: `ubuntu:22.04`를 기반으로, 애플리케이션 실행에 필요한 모든 서버 소프트웨어를 설치합니다.
    -   **웹/애플리케이션 서버**: Nginx, PHP 7.2-FPM, Node.js 16.x
    -   **데이터베이스 서버**: MySQL Server (컨테이너 내부 설치)
    -   **기타**: OpenSSH Server, 각종 빌드 도구 및 유틸리티
    -   **MySQL 설정**: `my.cnf` 파일을 직접 수정하여 외부 접속 허용, 포트 변경(53306), 타임존 및 캐릭터셋(utf8mb4) 설정을 적용합니다.

-   **`docker-compose.yml`**:
    -   **단일 서비스 `os`**: 모든 컴포넌트가 설치된 `Dockerfile`을 빌드하여 `docker_nodam`이라는 이름의 컨테이너를 생성합니다.
    -   **포트 매핑**:
        -   `52530`: 관리자 ERP (PHP)
        -   `52532`: HTTP 서버 (Node.js)
        -   `52533`: TCP/IP 소켓 서버 (Node.js)
        -   `53306`: MySQL 데이터베이스
        -   `2236`: SSH
    -   **소스코드 및 설정 마운트**:
        -   `./home/ubuntu/node`: Node.js 소스코드
        -   `./var/www/html`: PHP 소스코드 (웹 루트)
        -   `./etc/nginx/sites-available/default`: Nginx 사이트 설정
        -   이러한 구조는 호스트에서 소스코드와 설정을 직접 수정하고 관리할 수 있게 합니다.
    -   **데이터 영속성**: `nodam_dbconfig`, `nodam_dbdata`라는 외부 볼륨을 사용하여 MySQL의 설정과 데이터를 컨테이너가 삭제되어도 안전하게 보존합니다.

### 시스템 구동 워크플로우 (`start_service.sh`)

1.  **서버 데몬 실행**: SSH, PHP-FPM, Nginx, MySQL 서비스를 순차적으로 시작합니다.
2.  **데이터베이스 초기화**:
    -   MySQL 서버가 완전히 구동될 때까지 대기합니다.
    -   MySQL `root` 계정의 비밀번호를 스크립트 내에서 설정합니다.
    -   `nodam.sql` 파일을 `mysql` 클라이언트로 실행하여, 사전에 정의된 데이터베이스 스키마와 데이터를 모두 임포트합니다. 이를 통해 컨테이너는 항상 동일한 데이터 상태에서 시작합니다.
3.  **Node.js 애플리케이션 실행**:
    -   `npm install` 명령어로 의존성 모듈을 설치합니다.
    -   `node index.js &`: 메인 HTTP 서버를 백그라운드로 실행합니다.
    -   `node socket.js &`: 실시간 통신을 위한 소켓 서버를 백그라운드로 실행합니다.

## 기술 스택

-   **오케스트레이션**: Docker, Docker Compose
-   **백엔드**: Node.js, PHP 7.2
-   **웹 서버**: Nginx
-   **데이터베이스**: MySQL
-   **주요 언어**: JavaScript (Node.js), PHP

## 실행 방법

### 사전 요구사항

-   Docker 및 Docker Compose
-   `nodam_dbconfig`, `nodam_dbdata` 라는 이름의 Docker 외부 볼륨이 사전에 생성되어 있어야 합니다.
    ```bash
    docker volume create nodam_dbconfig
    docker volume create nodam_dbdata
    ```

### 실행

1.  **Docker 이미지 빌드 및 컨테이너 실행**:
    ```bash
    # (선택) 재빌드 및 실행 스크립트
    ./rebuild_docker.sh

    # 또는 docker-compose 직접 실행
    docker-compose up --build -d
    ```
    최초 실행 시 `nodam.sql` 파일을 통해 데이터베이스를 구축하므로 다소 시간이 걸릴 수 있습니다.

2.  **애플리케이션 접근**:
    -   **관리자 ERP**: `http://<서버_IP>:52530`
    -   **메인 서비스 (HTTP)**: `http://<서버_IP>:52532`
    -   기타 서비스는 `docker-compose.yml`의 포트 매핑을 참고하여 접근합니다.

### 중지

```bash
docker-compose down
``` 