# Poste.io 메일 서버

이 프로젝트는 오픈소스 메일 서버 솔루션인 [Poste.io](https://poste.io/)를 Docker를 사용하여 간단하게 배포하기 위한 설정입니다. `docker-compose`를 사용하여 메일 서버에 필요한 모든 서비스를 한 번에 실행합니다.

## 주요 기능

- **올인원 메일 서버**: `analogic/poste.io` 이미지를 사용하여 SMTP, IMAP, POP3, 안티바이러스, 웹메일 등 전체 메일 기능을 제공합니다.
- **데이터 영속성**: 메일 데이터는 Docker 볼륨(`mailserver_posteio`)에 저장되어 컨테이너를 재생성해도 유지됩니다.
- **SSL 지원**: 로컬의 `certs` 디렉토리를 통해 SSL 인증서를 관리할 수 있습니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)
- **도메인 및 DNS 설정**: 메일 서버로 사용할 도메인(예: `mail.geumdo.net`)과 해당 도메인의 MX, A 레코드가 서버 IP를 가리키도록 설정되어 있어야 합니다.

## 사용 방법

### 1. 서비스 시작

아래 스크립트를 실행하여 Docker 볼륨을 생성하고 메일 서버 컨테이너를 시작합니다.

```bash
./rebuild.sh
```

스크립트는 `mailserver_posteio` 볼륨을 생성하고 `docker-compose.yml`에 정의된 대로 `poste.io` 컨테이너를 백그라운드에서 실행합니다.

### 2. 초기 설정

서비스가 시작되면 웹 브라우저를 통해 관리자 인터페이스에 접속하여 초기 설정을 진행해야 합니다.

- **관리자 UI 주소**: `https://<서버_IP>:4433`
- **초기 접속 정보**: 최초 접속 시 시스템 관리자 계정(예: `admin@mail.geumdo.net`)과 비밀번호를 생성하게 됩니다.

### 3. SSL 인증서 설정

HTTPS 및 보안 메일 통신(SMTPS, IMAPS 등)을 위해 SSL 인증서가 필요합니다. `certs` 디렉토리에 개인 키(`privkey.pem`)와 인증서(`cert.pem` 또는 `fullchain.pem`)를 위치시킨 후 컨테이너를 재시작하면 적용됩니다.

```
.
├── docker-compose.yml
├── rebuild.sh
└── certs/
    ├── privkey.pem   <-- 여기에 개인 키 파일
    └── cert.pem      <-- 여기에 인증서 파일
```
만약 Let's Encrypt 자동 발급 연동 환경이 구성되어 있다면, 이 폴더는 자동으로 채워질 수 있습니다.

## 포트 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 설명 |
|---|---|---|---|
| SMTP | 25 | 25 | 메일 발송 |
| HTTP | 8800 | 80 | 관리자 UI / 웹메일 (HTTPS로 리다이렉트됨) |
| HTTPS | 4433 | 443 | 관리자 UI / 웹메일 |
| POP3 | 110 | 110 | 메일 수신 |
| IMAP | 143 | 143 | 메일 수신 |
| SMTPS | 465 | 465 | SMTP over SSL |
| Submission| 587 | 587 | 메일 제출 (STARTTLS) |
| IMAPS | 993 | 993 | IMAP over SSL |
| POP3S | 995 | 995 | POP3 over SSL |
| ManageSieve| 4190| 4190| 메일 필터 규칙 관리 | 