# Jupyter Lab Docker 환경

이 프로젝트는 GPU를 지원하는 Jupyter Lab 실행 환경을 Docker를 사용하여 구축합니다. 사전 구성된 Python 3.10 환경, SSH 접속, 영구적인 노트북 저장 공간을 제공합니다.

## 주요 기능

- **베이스 이미지**: Ubuntu 22.04
- **Python 버전**: Python 3.10 (venv 가상 환경)
- **주요 라이브러리**:
  - Jupyter Lab
  - PyTorch (NVIDIA GPU 지원)
  - `requirements.txt`에 명시된 기타 라이브러리
- **서비스**:
  - Jupyter Lab 웹 인터페이스
  - SSH 서버 접속

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)
- (GPU 사용 시) [NVIDIA Docker Toolkit](https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/latest/install-guide.html)

## 사용 방법

### 1. 서비스 시작

아래 명령어를 실행하여 Docker 컨테이너를 빌드하고 백그라운드에서 실행합니다.

```bash
docker-compose up -d
```

### 2. 이미지 재빌드

`Dockerfile`이나 환경에 변경 사항이 있을 경우, 아래 스크립트를 실행하여 이미지를 다시 빌드하고 서비스를 시작할 수 있습니다.

```bash
./rebuild.sh
```

## 서비스 접속 정보

### Jupyter Lab

- **URL**: `http://<서버_IP>:8888`
- **비밀번호**: `123`

### SSH

- **명령어**: `ssh root@<서버_IP> -p 2115`
- **비밀번호**: `!@#gds$%^`

## 파일 및 디렉토리 설명

- `Dockerfile`: Docker 이미지를 빌드하기 위한 설정 파일입니다. OS, 시스템 패키지, Python 라이브러리 등이 정의되어 있습니다.
- `docker-compose.yml`: Docker 서비스를 관리하기 위한 파일입니다. 포트 매핑, 볼륨 마운트, GPU 할당 등을 설정합니다.
- `requirements.txt`: Python 가상 환경에 설치될 패키지 목록입니다.
- `notebooks/`: Jupyter 노트북 파일이 저장되는 디렉토리입니다. 이 디렉토리는 컨테이너의 `/app/notebooks`와 마운트되어 데이터가 영구적으로 보존됩니다.
- `rebuild.sh`: 이미지를 다시 빌드하고 컨테이너를 재시작하는 스크립트입니다.
- `start_service.sh`: 컨테이너 내부에서 SSH 서비스를 시작하는 스크립트입니다. 