# Jenkins CI/CD 서버

이 프로젝트는 Docker를 사용하여 Jenkins CI/CD 자동화 서버를 구축하기 위한 환경입니다. Ubuntu 20.04 위에 OpenJDK 8과 Jenkins가 설치되며, 데이터는 호스트의 로컬 디렉토리에 영속적으로 저장됩니다.

## 주요 기능

- **기반 환경**: Ubuntu 20.04, OpenJDK 8
- **CI/CD 서버**: Jenkins (공식 저장소에서 설치)
- **데이터베이스**: MariaDB Server/Client 포함 (Jenkins 작업에서 필요시 사용 가능)
- **원격 접속**: OpenSSH Server
- **데이터 영속성**: Jenkins의 모든 설정, 작업 내역, 로그가 호스트의 `jenkins_data`, `jenkins_log` 디렉토리에 바인드 마운트되어 보존됩니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

### 1. 서비스 시작 및 빌드

아래 스크립트를 실행하여 Docker 이미지를 빌드하고 Jenkins 컨테이너를 시작합니다.

```bash
./rebuild.sh
```

스크립트를 실행하면 현재 디렉토리에 `jenkins_data`와 `jenkins_log` 폴더가 자동으로 생성되며, 컨테이너의 데이터 및 로그와 동기화됩니다.

### 2. 초기 관리자 비밀번호 확인

Jenkins가 처음 실행되면 초기 관리자 비밀번호가 생성됩니다. 이 비밀번호는 웹 UI에 처음 접속할 때 필요합니다. 아래 명령어로 확인할 수 있습니다.

```bash
# 컨테이너가 완전히 실행된 후 잠시 기다렸다가 실행
docker exec -it jenkins-jenkins-1 cat /var/jenkins_home/secrets/initialAdminPassword
```
*참고: `jenkins-jenkins-1`은 `docker ps`로 확인한 실제 컨테이너 이름으로 변경해야 할 수 있습니다.*

### 3. Jenkins 초기 설정

1.  웹 브라우저에서 `http://<서버_IP>:8087` 주소로 접속합니다.
2.  위 단계에서 확인한 **Administrator password**를 입력합니다.
3.  'Install suggested plugins'를 선택하여 추천 플러그인을 설치하고, 관리자 계정을 생성하여 설정을 완료합니다.

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 설명 |
|---|---|---|---|
| Jenkins Web UI | `8087` | `8080` | `http://<서버_IP>:8087` |
| Jenkins Agent | `50000` | `50000` | Jenkins 에이전트 연결 포트 |
| SSH | `2116` | `22` | `ssh root@<서버_IP> -p 2116` (root/!@#gds$%^) | 