# Java / Tomcat / MariaDB Docker 환경

이 프로젝트는 Java 웹 애플리케이션을 위한 완전한 Docker 환경을 제공합니다. Ubuntu 20.04를 기반으로 OpenJDK 8, Tomcat 8.5, MariaDB 서버 및 SSH 서버를 포함하고 있습니다.

## 주요 기능

- **베이스 이미지**: Ubuntu 20.04
- **Java**: OpenJDK 8, Maven
- **웹 애플리케이션 서버(WAS)**: Apache Tomcat 8.5.98
- **데이터베이스**: MariaDB Server
- **원격 접속**: OpenSSH Server

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

제공되는 쉘 스크립트를 사용하여 Docker 볼륨 생성, 이미지 빌드, 서비스 시작을 한 번에 처리할 수 있습니다.

### 1. 서비스 시작 및 빌드

아래 명령어를 실행하여 Docker 컨테이너를 빌드하고 백그라운드에서 실행합니다.

```bash
./rebuild_docker.sh
```

이 스크립트는 다음 작업을 자동으로 수행합니다:
1.  데이터베이스, WAS 설정 등을 저장하기 위한 Docker 볼륨(`dbdata`, `dbconfig`, `wasconfig`, `data`, `wardata`)을 확인하고 없는 경우 생성합니다.
2.  `Dockerfile`을 기반으로 이미지를 빌드합니다.
3.  `docker-compose.yml` 설정을 사용하여 서비스를 시작합니다.

### 2. 서비스 중지

실행 중인 서비스를 중지하려면 아래 명령어를 사용합니다.

```bash
docker-compose down
```

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2233` | `22` | `ssh root@<서버_IP> -p 2233` | `root` | `!@#gds$%^` |
| Tomcat (HTTP) | `8092` | `8080` | `http://<서버_IP>:8092` | - | - |
| Tomcat (HTTPS)| `4446` | `443`  | `https://<서버_IP>:4446` | - | - |
| MariaDB | `33064`| `3306` | `<서버_IP>` | `root` | `fnxmdkagh` |

## 데이터 영속성 및 설정

이 환경은 Docker 볼륨 및 바인드 마운트를 사용하여 데이터와 설정을 컨테이너 외부 호스트에 영속적으로 저장합니다.

- **볼륨**:
  - `dbdata`: MariaDB 데이터 파일 (`/var/lib/mysql`)
  - `dbconfig`: MariaDB 설정 파일 (`/etc/mysql`)
  - `wasconfig`: Tomcat 설정 파일 (`/usr/local/tomcat/conf`)
  - `wardata`: Tomcat 웹 애플리케이션 (`/usr/local/tomcat/webapps`)
  - `data`: 범용 데이터 저장용 (`/data`)
- **바인드 마운트**:
  - `./ssl/`: SSL 인증서를 저장하는 로컬 디렉토리입니다. 이 폴더에 있는 파일들은 컨테이너의 `/usr/local/tomcat/ssl` 경로에 마운트됩니다. HTTPS를 사용하려면 이곳에 인증서와 키 파일을 위치시켜야 합니다. 