# GitLab CE (Community Edition) 서버

이 프로젝트는 Docker Compose를 사용하여 GitLab Community Edition (CE) 서버를 간편하게 배포하기 위한 설정입니다.

## 주요 기능

- **GitLab CE**: `gitlab/gitlab-ce` 공식 이미지를 사용하여 완전한 GitLab 환경을 제공합니다.
- **데이터 영속성**: GitLab의 설정, 로그, 데이터는 모두 호스트의 특정 디렉토리(`GITLAB_HOME`)에 마운트되어 영속적으로 관리됩니다.
- **HTTPS 기본 설정**: `gitlab.geumdo.net` 도메인에 대한 HTTPS 접속 및 HTTP에서 HTTPS로의 자동 리다이렉션이 미리 설정되어 있습니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)
- **도메인 및 DNS 설정**: GitLab 서버로 사용할 도메인(예: `gitlab.geumdo.net`)과 해당 도메인의 A 레코드가 서버 IP를 가리키도록 설정되어 있어야 합니다.
- **호스트 디렉토리**: GitLab 데이터를 저장할 호스트 디렉토리를 준비해야 합니다. 기본값은 `/srv/gitlab` 입니다.
- **SSL 인증서**: HTTPS 서비스를 위해 유효한 SSL 인증서가 필요합니다.

## 사용 방법

### 1. 환경 변수 및 디렉토리 설정

`.env` 파일은 `GITLAB_HOME`을 `/srv/gitlab`으로 설정합니다. 다른 경로를 사용하려면 이 파일을 수정하거나 쉘 환경 변수를 직접 설정하십시오.

```bash
# 기본 경로인 /srv/gitlab 디렉토리 생성
mkdir -p /srv/gitlab
```

### 2. SSL 인증서 준비

HTTPS 접속을 위해 SSL 인증서와 키, dhparam 파일을 준비하여 GitLab 설정 디렉토리 내 `ssl` 폴더에 위치시켜야 합니다.

```bash
# /srv/gitlab/config/ssl 디렉토리 생성
mkdir -p /srv/gitlab/config/ssl

# 인증서 파일들을 해당 경로로 복사
# cp <your_fullchain.pem> /srv/gitlab/config/ssl/fullchain.pem
# cp <your_privkey.pem> /srv/gitlab/config/ssl/privkey.pem
# cp <your_dhparams.pem> /srv/gitlab/config/ssl/dhparams.pem # (선택 사항이지만 권장)
```
`docker-compose.yml`은 이 경로의 인증서를 사용하도록 설정되어 있습니다.

### 3. 서비스 시작

아래 명령어를 실행하여 GitLab 컨테이너를 시작합니다. 최초 실행 시 GitLab을 초기화하는 데 몇 분 정도 소요될 수 있습니다.

```bash
docker-compose up -d
```

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 |
|---|---|---|---|
| HTTPS | `4430` | `443` | `https://gitlab.geumdo.net:4430` |
| HTTP | `8081` | `80` | `http://gitlab.geumdo.net:8081` (HTTPS로 자동 리다이렉트) |
| SSH | `2224` | `22` | (Git 클라이언트가 사용) |

### 초기 관리자 비밀번호 확인

GitLab이 처음 실행되면 초기 관리자(`root`) 계정의 비밀번호가 자동으로 생성됩니다. 아래 명령어로 확인할 수 있습니다.

```bash
# 컨테이너가 완전히 실행된 후 (몇 분 소요)
docker exec -it gitlab-web-1 grep 'Password:' /etc/gitlab/initial_root_password
```
확인된 비밀번호를 사용하여 웹 인터페이스에 `root` 계정으로 로그인한 후 즉시 변경하는 것을 권장합니다. 