# Flask 기반 HTTPS 리버스 프록시

이 프로젝트는 Flask를 사용하여 특정 URL로의 요청을 대신 전달해주는 간단한 HTTPS 리버스 프록시 서버를 Docker로 실행합니다.

## 주요 기능

- **프록시**: `/proxy?url=<TARGET_URL>` 형식으로 요청을 받아 `<TARGET_URL>`로 요청을 전달하고 응답을 반환합니다.
- **HTTPS 지원**: 제공된 SSL 인증서를 사용하여 HTTPS 서버로 동작합니다.
- **CORS 지원**: 모든 출처(`*`)에 대해 CORS(Cross-Origin Resource Sharing)를 허용합니다.
- **HTTP to HTTPS 리다이렉트**: 모든 HTTP 요청을 자동으로 HTTPS로 리다이렉트합니다.
- **로깅**: 모든 프록시 활동과 오류를 `proxy_app.log` 파일에 기록합니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)
- **SSL 인증서**: HTTPS 서비스를 위해 유효한 SSL 인증서 파일(`cert.pem`)과 개인 키 파일(`privkey.pem`)이 필요합니다.

## 사용 방법

### 1. SSL 인증서 준비

프로젝트 루트 디렉토리에 `proxy.geumdo.net` 폴더를 생성하고, 내부에 `cert.pem`과 `privkey.pem` 파일을 위치시킵니다.

```
.
├── Dockerfile
├── app.py
├── docker-compose.yml
└── proxy.geumdo.net/
    ├── cert.pem      <-- 여기에 인증서 파일
    └── privkey.pem   <-- 여기에 개인 키 파일
```

### 2. 서비스 시작 및 빌드

아래 스크립트를 실행하여 Docker 이미지를 빌드하고 컨테이너를 시작합니다.

```bash
./rebuild_docker.sh
```

이 스크립트는 `docker-compose.yml` 설정을 사용하여 컨테이너를 백그라운드에서 실행합니다.

## 서비스 접속 정보

- **서비스 포트**: 호스트의 `3001`번 포트가 컨테이너의 `3000`번 포트로 매핑됩니다.
- **엔드포인트**: `https://<서버_IP>:3001/proxy`

### 사용 예시

`https://www.google.com` 으로 프록시 요청을 보내려면 아래와 같이 호출합니다.

```
https://<서버_IP>:3001/proxy?url=https://www.google.com
```

## 코드 수정 및 반영

이 프로젝트는 로컬의 `app.py` 파일을 컨테이너 내부로 직접 마운트합니다. 따라서 `app.py` 파일의 내용을 수정한 후, 아래 명령어로 컨테이너를 재시작하면 변경 사항이 즉시 반영됩니다.

```bash
docker-compose restart
``` 