# AI 감성 분석 및 크롤링 시스템

본 프로젝트는 마케팅 전략 수립 및 상품 개선을 위한 데이터 수집 및 AI 감성 분석 시스템입니다. Docker를 기반으로 패키징되어 있으며, FastAPI를 통해 API를 제공합니다.

## 기술 아키텍처

시스템은 크게 데이터 수집(Crawling), 데이터 분석(Analysis), API 제공(Serving)의 3가지 핵심 기능으로 구성됩니다.

-   **`Dockerfile`**: `ubuntu:22.04`를 기반으로 하며, 애플리케이션 실행에 필요한 복잡한 환경을 구성합니다.
    -   **핵심 의존성**: Python 3.10, Java 8 JDK, Mecab (한국어 형태소 분석기), Google Chrome.
    -   Java JDK는 한국어 형태소 분석기 라이브러리인 `Eunjeon`의 의존성 해결을 위해 설치됩니다.
    -   Google Chrome과 관련 라이브러리(`lib*`) 및 `webdriver`는 `Selenium`을 사용한 웹 크롤링 기능을 위해 설치됩니다.
-   **`docker-compose.yml`**:
    -   `fastapi_new_server`라는 이름의 단일 서비스를 실행합니다.
    -   `shm_size: 2g`: Selenium으로 Chrome을 실행할 때 발생할 수 있는 크래시를 방지하기 위해 컨테이너의 공유 메모리 크기를 2GB로 설정합니다.
    -   호스트의 8001 포트를 컨테이너의 8001 포트와 매핑합니다.

### 워크플로우

1.  **데이터 수집 (Crawling)**:
    -   `api/crawling/` 디렉토리의 `smartstore.py`, `coupang.py` 모듈이 크롤링 로직을 담당합니다.
    -   `Selenium`, `BeautifulSoup`, `undetected-chromedriver`를 사용하여 스마트스토어, 쿠팡과 같은 이커머스 사이트에서 상품 리뷰 등의 데이터를 동적으로 수집합니다.

2.  **데이터 분석 (Analysis)**:
    -   **전처리**: `KoNLPy`, `Mecab`, `Eunjeon` 등의 라이브러리를 사용하여 수집된 한글 텍스트 데이터를 형태소 단위로 분석하고 정제합니다.
    -   **AI 분석**: `api/analysis/` 디렉토리의 `sentiment.py`(감성 분석), `associate.py`(연관 분석) 모듈이 분석 로직을 담당합니다.
        -   `TensorFlow`와 `Keras`로 구축된 딥러닝 모델을 사용하여 텍스트의 긍/부정 뉘앙스를 판단하는 감성 분석을 수행합니다.

3.  **API 제공 (Serving)**:
    -   `FastAPI`를 사용하여 분석 기능을 REST API 형태로 제공합니다.
    -   `app/server.py`에서 라우터를 관리하며, 인증(`auth`), 크롤링, 분석 등 기능별로 엔드포인트를 모듈화하여 관리합니다.
    -   `core/middleware/token_validator.py`를 통해 API 요청에 대한 토큰 기반 인증을 수행하여 허가된 사용자만 접근할 수 있도록 합니다.

## 기술 스택

-   **백엔드**: FastAPI, Uvicorn, Gunicorn
-   **웹 크롤링**: Selenium, BeautifulSoup4, undetected-chromedriver
-   **자연어 처리**: KoNLPy, Mecab, Eunjeon
-   **AI/머신러닝**: TensorFlow, Keras, Scikit-learn
-   **데이터베이스**: (Dockerfile 및 requirements.txt에 명시적인 DB 드라이버가 없어, 파일 기반 또는 외부 DB 연결로 추정됨)
-   **오케스트레이션**: Docker, Docker Compose

## 실행 방법

### 사전 요구사항

-   Docker 및 Docker Compose

### 설정

프로젝트에 필요한 환경 변수(예: DB 정보, 외부 API 키 등)는 `core/config.py` 또는 시스템 환경 변수를 통해 설정해야 합니다. (관련 설정 파일 확인 필요)

### 실행

1.  **Docker 이미지 빌드 및 컨테이너 실행**:
    ```bash
    # (선택) 기존 컨테이너 및 이미지 재빌드를 위한 스크립트
    ./rebuild.sh

    # 또는 docker-compose 직접 실행
    docker-compose up --build -d
    ```

2.  **애플리케이션 접근**:
    -   **API 문서 (Swagger UI)**: 컨테이너 실행 후, 브라우저에서 `http://localhost:8001/docs`로 접속하여 API 명세를 확인할 수 있습니다.

### 중지

```bash
docker-compose down
``` 