# RECLAR (SABG) 크롤링 & 감성분석 시스템 🚀

## 📋 프로젝트 개요

RECLAR은 제품별 마케팅 전략 데이터 확보 및 상품개선을 위한 AI 감성분석 시스템입니다. 스마트스토어와 쿠팡에서 상품 정보와 리뷰를 수집하고, 이를 분석하여 마케팅 인사이트를 제공합니다.

### 🎯 주요 기능

- **🔄 동적 마켓 크롤링**: 확장 가능한 아키텍처로 새로운 마켓을 쉽게 추가
- **📊 실시간 성능 모니터링**: 크롤링 성능을 실시간으로 추적 및 분석
- **🤖 AI 감성 분석**: 수집된 리뷰 데이터의 감성 분석
- **📝 구조화된 로깅**: 마켓별 분리된 로그 관리 및 메트릭 수집
- **🔗 연관 분석**: 상품 및 리뷰 데이터의 연관성 분석

---

## 🏗 프로젝트 구조 (정리됨)

```
docker_fastapi/
├── 📁 fastapi/                     # 메인 FastAPI 애플리케이션
│   ├── 📁 app/                     # 애플리케이션 진입점
│   ├── 📁 api/                     # API 라우터
│   │   ├── 📁 analysis/            # 데이터 분석 API
│   │   ├── 📁 auth/                # 인증 API
│   │   ├── 📁 crawling/            # 크롤링 API
│   │   └── 📁 monitoring/          # 모니터링 API
│   ├── 📁 core/                    # 핵심 비즈니스 로직
│   │   ├── 📄 crawler_base.py      # 공통 크롤링 베이스 클래스
│   │   ├── 📄 crawler_factory.py   # 크롤러 팩토리 패턴
│   │   ├── 📁 crawlers/            # 마켓별 크롤러
│   │   ├── 📁 exceptions/          # 예외 처리
│   │   ├── 📁 middleware/          # 미들웨어
│   │   └── 📁 utils/               # 유틸리티
│   ├── 📁 config/                  # 설정 파일
│   │   └── 📁 parsing_rules/       # 파싱 규칙
│   ├── 📁 databases/               # 데이터베이스 관련
│   ├── 📁 ml/                      # 머신러닝 모델
│   │   └── 📁 sentiment/           # 감성 분석
│   ├── 📁 tests/                   # 테스트 파일 (정리됨)
│   │   ├── 📁 integration/         # 통합 테스트
│   │   └── 📁 manual/              # 수동 테스트
│   ├── 📁 logs/                    # 로그 파일 (새로 생성)
│   │   ├── 📁 smartstore/          # 스마트스토어 로그
│   │   ├── 📁 coupang/            # 쿠팡 로그
│   │   └── 📁 metrics/            # 성능 메트릭
│   └── 📁 docs/                    # 문서
├── 📁 assets/                      # 바이너리 파일 (새로 생성)
│   └── 📁 chrome/                  # Chrome 관련 파일
│       ├── 📄 chromedriver         # 이동됨
│       └── 📄 google-chrome...deb  # 이동됨
├── 📁 scripts/                     # 개발 스크립트 (새로 생성)
│   └── 📄 rebuild.sh               # 이동됨
├── 📁 backup_monitoring/           # 백업된 모니터링 폴더
├── 📁 venv/                        # 파이썬 가상환경
├── 📄 docker-compose.yml           # Docker 설정
├── 📄 Dockerfile                   # Docker 이미지 설정 (업데이트됨)
└── 📄 README.md                    # 프로젝트 문서 (업데이트됨)
```

### 🔄 정리된 내용

1. **테스트 파일 정리**: 
   - 루트에 산재되어 있던 테스트 파일들을 `fastapi/tests/` 하위로 이동
   - `integration/` (통합 테스트)와 `manual/` (수동 테스트)로 분류

2. **바이너리 파일 정리**:
   - Chrome 설치 파일과 chromedriver를 `assets/chrome/`으로 이동
   - Dockerfile에서 경로 업데이트

3. **스크립트 정리**:
   - 개발 스크립트들을 `scripts/` 디렉토리로 이동

4. **로그 디렉토리 생성**:
   - 마켓별 로그 관리를 위한 구조 생성

5. **중복 폴더 정리**:
   - 루트의 `monitoring/` 폴더를 `backup_monitoring/`으로 백업

---

## 🚀 빠른 시작

### 1. 환경 설정

```bash
# 저장소 클론
git clone <repository-url>
cd docker_fastapi

# 가상환경 활성화
source venv/bin/activate

# FastAPI 의존성 설치
cd fastapi
pip install -r requirements.txt
```

### 2. 서버 실행

```bash
# Docker Compose 사용 (권장)
docker-compose up -d

# 또는 직접 실행
cd fastapi
python main.py

# 또는 uvicorn으로 실행
uvicorn app.server:app --host 0.0.0.0 --port 8000 --reload
```

### 3. API 문서 확인

- **Swagger UI**: http://localhost:8000/docs
- **ReDoc**: http://localhost:8000/redoc

---

## 📚 API 사용 가이드

### 🔄 동적 크롤링 API

#### 지원 마켓 조회
```bash
GET /crawling/markets
```

#### 상품 정보 크롤링
```bash
GET /crawling/{market}/product?url={상품URL}

# 예시
GET /crawling/smartstore/product?url=https://smartstore.naver.com/...
GET /crawling/coupang/product?url=https://www.coupang.com/vp/products/...
```

#### 리뷰 정보 크롤링
```bash
GET /crawling/{market}/reviews?url={상품URL}
```

### 📊 성능 모니터링 API

#### 성능 요약
```bash
GET /monitoring/performance/summary?market=smartstore
```

#### 종합 대시보드
```bash
GET /monitoring/performance/dashboard?market=smartstore
```

#### 시스템 헬스 체크
```bash
GET /monitoring/performance/health
```

---

## 🧪 테스트

### 테스트 실행

```bash
cd fastapi

# 모든 테스트 실행
pytest

# 통합 테스트만 실행
pytest tests/integration/

# 수동 테스트 (개별 실행)
python tests/manual/test_simple_manual.py

# 특정 마커별 테스트 실행
pytest -m unit          # 유닛 테스트만
pytest -m integration   # 통합 테스트만
pytest -m manual        # 수동 테스트만

# 커버리지 포함 실행
pytest --cov=core --cov-report=html
```

### 테스트 구조

```
📁 fastapi/tests/
├── 📁 integration/               # 통합 테스트
│   ├── 📄 test_system.py
│   ├── 📄 test_monitoring_system.py
│   └── 📄 test_updated_crawler.py
├── 📁 manual/                    # 수동 테스트
│   ├── 📄 test_simple_manual.py
│   ├── 📄 test_korean_sentiment.py
│   ├── 📄 test_navigate_to_url.py
│   └── 📄 test_coupang_manual.py
├── 📄 test_crawler_base.py       # 유닛 테스트
├── 📄 test_rule_loader.py
├── 📄 test_crawler_factory.py
└── 📄 test_integration.py
```

---

## 📊 로깅 및 모니터링

### 로그 파일 구조

```
📁 fastapi/logs/
├── 📁 smartstore/
│   ├── 📄 crawler.log           # 일반 로그
│   └── 📄 error.log             # 에러 로그
├── 📁 coupang/
│   ├── 📄 crawler.log
│   └── 📄 error.log
└── 📁 metrics/
    ├── 📄 metrics_2024-01-15.jsonl      # 일반 메트릭
    └── 📄 performance_2024-01-15.jsonl  # 성능 메트릭
```

### 로그 특징

- **마켓별 분리**: 각 마켓의 로그를 독립적으로 관리
- **로그 회전**: 10MB 파일 크기 제한, 5개 백업 파일 유지
- **구조화된 로깅**: JSON 형태로 분석 용이성 향상
- **성능 메트릭**: 자동 수집 및 저장

---

## 🔧 개발 가이드

### 새로운 마켓 크롤러 추가

1. `fastapi/core/crawlers/` 디렉토리에 새 크롤러 파일 생성
2. `BaseCrawler`를 상속받아 구현
3. `fastapi/config/parsing_rules/`에 파싱 규칙 추가
4. 자동으로 크롤러 팩토리에 등록됨

### 스크립트 실행

```bash
# 프로젝트 재빌드
./scripts/rebuild.sh

# 코드베이스 정리 (이미 실행됨)
./organize_structure.sh
```

---

## 🤝 기여하기

1. Fork the repository
2. Create your feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
4. Push to the branch (`git push origin feature/AmazingFeature`)
5. Open a Pull Request

---

## 📄 라이선스

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

---

## ⚠️ 주의사항

- Chrome과 chromedriver는 호환되는 버전을 사용해야 합니다
- 크롤링 시 해당 사이트의 robots.txt와 이용약관을 준수해야 합니다
- 과도한 요청으로 인한 서버 부하를 방지하기 위해 적절한 딜레이를 설정하세요 
