# MariaDB Docker 환경

이 프로젝트는 Ubuntu 20.04 기반의 MariaDB 서버 환경을 Docker를 사용하여 구축합니다. SSH 접속 또한 가능합니다.

## 주요 기능

- **베이스 이미지**: Ubuntu 20.04
- **데이터베이스**: MariaDB Server
- **원격 접속**: OpenSSH Server

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

### 1. 서비스 시작 및 빌드

프로젝트 루트 디렉토리에서 아래 쉘 스크립트를 실행합니다.

```bash
./rebuild.sh
```

이 스크립트는 다음 작업을 자동으로 수행합니다:
1.  MariaDB 데이터를 영속적으로 저장하기 위한 Docker 볼륨(`dbdata`)을 확인하고 없는 경우 생성합니다.
2.  `Dockerfile`을 기반으로 이미지를 빌드합니다.
3.  `docker-compose.yml` 설정을 사용하여 서비스를 시작합니다.

### 2. MariaDB 원격 접속 계정 설정 (수동)

컨테이너가 실행된 후, 원격에서 MariaDB에 접속하려면 아래의 추가 설정이 필요합니다.

먼저, 실행중인 컨테이너의 이름이나 ID를 확인합니다.
```bash
docker ps
```

그런 다음, 아래 명령어를 실행하여 컨테이너 내부의 설정 스크립트를 실행합니다.
```bash
# `docker_db_new_server_1`은 예시 컨테이너 이름입니다. `docker ps` 명령어로 확인한 실제 컨테이너 이름으로 바꿔주세요.
docker exec -it docker_db_new_server_1 /bin/bash -c "./make_root_remote_host.sh"
```
이 스크립트는 `root` 계정이 모든 외부 IP(`%`)에서 접속할 수 있도록 권한을 부여하고 비밀번호를 설정합니다.

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2113` | `22` | `ssh root@<서버_IP> -p 2113` | `root` | `!@#gds$%^` |
| MariaDB | `33066`| `3306` | `<서버_IP>` | `root` | `!@#gds$%^` |

**참고:** MariaDB의 `root` 계정은 컨테이너 최초 실행 시 비밀번호가 설정되어 있지 않습니다. 원격 접속 설정을 완료해야 위 테이블의 비밀번호로 접속 가능합니다.

## 데이터 영속성

- **볼륨**:
  - `dbdata`: MariaDB의 데이터 파일(`_path`)이 저장됩니다. 이 볼륨이 존재하면 컨테이너를 삭제하고 재생성해도 데이터가 보존됩니다. 