# MariaDB 서버 (자동 원격 설정)

이 프로젝트는 Ubuntu 20.04 기반의 MariaDB 서버 환경을 Docker를 사용하여 구축합니다. 컨테이너가 시작될 때 ** 자동으로 원격 접속이 가능한 `root` 계정을 설정**하여 사용자의 편의성을 높인 것이 특징입니다. SSH 접속 또한 가능합니다.

## 주요 기능

- **기반 환경**: Ubuntu 20.04
- **데이터베이스**: MariaDB Server
- **원격 접속**: OpenSSH Server
- **자동 설정**: 컨테이너 시작 시, 모든 IP에서 접근 가능한 `root` 계정을 생성하고 비밀번호를 설정하는 스크립트가 자동으로 실행됩니다.

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

프로젝트 루트 디렉토리에서 아래 쉘 스크립트를 실행하기만 하면 됩니다.

```bash
./rebuild.sh
```

이 스크립트는 다음 작업을 자동으로 수행합니다:
1.  MariaDB 데이터(`dbkeydata`)와 홈 디렉토리(`dbhome`)를 영속적으로 저장하기 위한 Docker 볼륨을 확인하고 없는 경우 생성합니다.
2.  `Dockerfile`을 기반으로 이미지를 빌드합니다.
3.  `docker-compose.yml` 설정을 사용하여 서비스를 시작합니다.
4.  컨테이너 내부적으로 원격 접속 설정을 완료합니다.

별도의 수동 설정 과정 없이 바로 데이터베이스에 원격으로 접속할 수 있습니다.

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2228` | `22` | `ssh root@<서버_IP> -p 2228` | `root` | `!@#gds$%^` |
| MariaDB | `33062`| `3306` | `<서버_IP>` | `root` | `!@#gds$%^` |
| 기타 | `9011`| `9011` | (용도 확인 필요) | - | - |
| 기타 | `9013`| `9013` | (용도 확인 필요) | - | - |

## 데이터 영속성 (볼륨)

- `dbkeydata`: MariaDB의 데이터 파일(`_path`)이 저장됩니다.
- `dbhome`: 컨테이너의 `/home` 디렉토리와 연결됩니다. 