# 크롤링/분석 FastAPI 서버

이 프로젝트는 프로젝트 루트(`../../`)에 위치한 `geumdo_analysis` 디렉토리의 Python 애플리케이션을 FastAPI 서버로 실행하기 위한 Docker 환경입니다.

**경고: 이 Docker 설정은 외부 디렉토리에 강하게 의존하고 있으며, 빌드와 실행 방식에 혼동의 여지가 있습니다. 아래 설명을 주의 깊게 읽어주세요.**

## 프로젝트 구조 및 의존성

- **소스 코드 위치**: 이 Docker 컨테이너는 `docker/docker_crowling` 폴더의 상위 폴더인 프로젝트 루트에 있는 `geumdo_analysis` 라는 디렉토리의 소스 코드를 실행하도록 설계되었습니다.
- **애플리케이션 타입**: `unicorn`을 사용하는 것으로 보아, `geumdo_analysis`는 FastAPI 또는 Starlette 기반의 ASGI 웹 애플리케이션일 가능성이 높습니다.
- **Dockerfile 동작**: 빌드 시 `geumdo_analysis` 폴더의 내용을 이미지 안으로 복사(`COPY`)합니다.
- **docker-compose 동작**: 컨테이너 실행 시, `fastapi_app` 이라는 외부 Docker 볼륨을 컨테이너의 `/app` 디렉토리에 마운트합니다. **이 과정에서 Dockerfile에 의해 복사된 소스 코드는 볼륨에 의해 덮어씌워져 무시됩니다.**

결론적으로, 이 컨테이너가 정상적으로 동작하려면 **`fastapi_app` 볼륨 내부에 `geumdo_analysis`의 소스 코드가 사전에 존재해야 합니다.**

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)
- 프로젝트 루트에 `geumdo_analysis` 소스 코드 폴더가 존재해야 합니다.
- `geumdo_analysis` 폴더 내에 `requirements.txt`와 `main.py` 파일(`app` 객체 포함)이 있어야 합니다.

## 사용 방법

### 1. (최초 설정) 소스 코드를 볼륨에 복사

`rebuild.sh`는 빈 볼륨만 생성해주므로, 사용자가 직접 소스 코드를 볼륨으로 옮겨야 합니다.

```bash
# 1. 빌드 스크립트를 실행하여 빈 볼륨과 이미지를 생성하고, 임시 컨테이너를 실행
./rebuild.sh

# 2. 프로젝트 루트의 geumdo_analysis 폴더 전체를 fastapi_server 컨테이너의 /app 디렉토리로 복사
# (컨테이너의 /app 디렉토리는 fastapi_app 볼륨과 연결되어 있음)
docker cp ../../geumdo_analysis/. fastapi_server:/app/

# 3. 임시 컨테이너 재시작하여 코드 변경사항 반영
docker-compose restart
```

### 2. (이후) 서비스 시작

이미 볼륨에 소스 코드가 준비된 상태라면, 아래 명령어로 서비스를 시작할 수 있습니다.
```bash
docker-compose up -d
```

## 서비스 접속 정보

- **서비스 포트**: 호스트의 `8100`번 포트가 컨테이너의 `8000`번 포트로 매핑됩니다.
- **API 주소**: `http://<서버_IP>:8100` 