#!/bin/bash

# Check and create volumes
create_volume() {
    docker volume inspect $1 > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        echo "Volume '$1' already exists."
    else
        docker volume create --name=$1
        echo "Volume '$1' created."
    fi
}

# Create volumes
create_volume dbdata_geumdo
create_volume dbconfig_geumdo
create_volume apconfig_geumdo
create_volume sourcedata_geumdo

# Build Docker image
docker build -t docker_centos .

# Run Docker Compose
docker-compose up --build -d
