# CentOS 6 기반 웹 서버 환경

이 프로젝트는 오래된 운영 환경인 CentOS 6.10을 기반으로 하는 완전한 웹 서버 환경을 Docker를 사용하여 구축합니다. Apache, PHP, MySQL(APM) 스택을 포함하며, 소스 코드 컴파일을 통해 최신 빌드 도구(GCC 8, Glibc 2.28 등)를 설치하여 레거시 시스템과의 호환성을 유지하면서도 개발 환경을 개선합니다.

## 주요 기능

- **베이스 이미지**: CentOS 6.10 (YUM 저장소 `vault.centos.org`로 재설정)
- **웹 서버**: Apache HTTP Server, PHP
- **데이터베이스**: MySQL Server
- **원격 접속**: OpenSSH Server
- **빌드 환경**:
  - `devtoolset-8` (GCC 8)
  - `glibc 2.28`, `binutils`, `make` 등 주요 라이브러리 및 도구를 소스 컴파일하여 설치

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

제공되는 쉘 스크립트를 사용하여 Docker 볼륨 생성, 이미지 빌드, 서비스 시작을 한 번에 처리할 수 있습니다.

### 1. 서비스 시작 및 빌드

아래 명령어를 실행하여 Docker 컨테이너를 빌드하고 백그라운드에서 실행합니다.

```bash
./rebuild_docker.sh
```

이 스크립트는 다음 작업을 자동으로 수행합니다:
1.  데이터, 설정 등을 영속적으로 저장하기 위한 Docker 볼륨(`dbdata_geumdo`, `dbconfig_geumdo`, `apconfig_geumdo`, `sourcedata_geumdo`)을 확인하고 없는 경우 생성합니다.
2.  `Dockerfile`을 기반으로 이미지를 빌드합니다. (최초 빌드 시 시간이 매우 오래 걸릴 수 있습니다.)
3.  `docker-compose.yml` 설정을 사용하여 서비스를 시작합니다.

### 2. 서비스 중지

실행 중인 서비스를 중지하려면 아래 명령어를 사용합니다.

```bash
docker-compose down
```

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2230` | `22` | `ssh root@<서버_IP> -p 2230` | `root` | `!@#gds$%^` |
| Apache HTTP | `8091` | `80` | `http://<서버_IP>:8091` | - | - |
| Apache HTTPS | `4445` | `443` | `https://<서버_IP>:4445`| - | - |
| MySQL | `33063` | `3306` | `<서버_IP>` | `root` | `!@#gds$%^` |


## 데이터 영속성 및 설정

- **볼륨**:
  - `dbdata_geumdo`: MySQL 데이터 파일 (`/var/lib/mysql`)
  - `dbconfig_geumdo`: MySQL 설정 파일 (`/etc/mysql`)
  - `apconfig_geumdo`: Apache 설정 파일 (`/etc/httpd`)
  - `sourcedata_geumdo`: 웹 소스 코드 디렉토리 (`/webFolder`)
- **설정 파일**:
  - 프로젝트 루트의 `httpd.conf`, `php.ini`, `my.cnf`, `sshd_config`, `ssl.conf` 파일이 빌드 시 이미지 내부의 설정 파일을 덮어씁니다. 서버 설정을 변경하려면 이 파일들을 수정한 후 `./rebuild_docker.sh`를 다시 실행해야 합니다.

## 기타 참고사항
1. SSH 접속이 되지 않을 경우, 컨테이너 내부에서 `service sshd restart` 명령 실행 후 재접속을 시도해 보십시오.
2. VSCode Remote 등으로 접속하여 터미널이 제대로 동작하지 않을 경우, `source /etc/profile` 명령을 실행하여 환경 변수를 다시 불러오십시오. 