#!/bin/bash

# Function to wait for a service to start
wait_for_service() {
    local service_name="$1"
    local max_attempts=30
    local delay=5

    echo "Waiting for $service_name to start..."
	    
    for ((i = 0; i < max_attempts; i++)); do
    	if systemctl is-active --quiet "$service_name"; then
        	echo "$service_name is running."
            	return 0
        fi
        sleep "$delay"
    done

    echo "Timed out waiting for $service_name to start."
    return 1
}

# SSH 서버 시작
/usr/sbin/sshd &

# MySQL 시작 및 루트 계정 생성 및 DB 초기화 							
service mysqld start
wait_for_service "mysqld"

mysql -u root --password=!@#gds$%^ < /service_script/setting.sql
mysql -u root --password=!@#gds$%^ < /service_script/dump.sql

# Apache 시작
service httpd start
wait_for_service "httpd"

# 무한 대기를 대신하여 스크립트 종료 방법 (Ctrl+C를 누르면 종료)
trap "exit" INT TERM
while true; do
    sleep 1
done
