#!/bin/bash

# Check and create volumes
create_volume() {
    docker volume inspect $1 > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        echo "Volume '$1' already exists."
    else
        docker volume create --name=$1
        echo "Volume '$1' created."
    fi
}

# Create volumes
create_volume dbdata_jobtp
create_volume dbconfig_jobtp
create_volume apconfig_jobtp
create_volume mailerdata

# Build Docker image
docker build -t docker_centos_os .

# Run Docker Compose
docker-compose up -d
