# CentOS 6 APM 서버 환경 (DB 복원 기능 포함)

이 프로젝트는 CentOS 6.10을 기반으로 하는 APM (Apache, PHP, MySQL) 스택과 SSH 서버를 Docker를 사용하여 구축합니다. 특히, 컨테이너 생성 시 대용량 SQL 덤프 파일(`dump.sql`)을 자동으로 복원하여 특정 데이터베이스 상태를 재현하는 것을 주 목적으로 합니다.

이 폴더에는 두 가지 유사한 환경 설정(`docker-compose.yml`, `docker-compose-centos.yml`)이 포함되어 있습니다.

## 환경 1: `docker-compose.yml` (주력 환경)

### 주요 기능

- **기반 환경**: CentOS 6.10, Apache, PHP, MySQL, OpenSSH
- **DB 자동 복원**: 컨테이너 시작 시 `/service_script/dump.sql` 파일을 MySQL에 자동으로 임포트합니다.
- **소스 코드 마운트**: 호스트의 `/webFolder5.6/jobtp` 디렉토리를 웹 소스 경로로 사용합니다.
- **데이터 영속성**: DB 데이터, 설정 등을 Docker 볼륨으로 관리합니다.

### 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)
- 호스트에 웹 소스 코드 디렉토리(`/webFolder5.6/jobtp`)가 존재해야 합니다.

### 사용 방법

`rebuild_docker.sh` 스크립트가 제공되지만, `docker-compose.yml`에 정의된 볼륨 이름과 스크립트가 생성하는 볼륨 이름이 달라 오류를 일으킬 수 있습니다. 아래의 수동 절차를 권장합니다.

**1. 볼륨 생성**
```bash
docker volume create dbdata_tp
docker volume create dbconfig_tp
docker volume create apconfig_tp
docker volume create mailerdata
```

**2. 빌드 및 시작**
```bash
# -f 옵션으로 사용할 compose 파일을 명시
docker-compose -f docker-compose.yml up -d --build
```
컨테이너가 시작되면 `start_service.sh` 스크립트가 실행되어 서비스 시작 및 DB 복원을 자동으로 수행합니다. (DB 복원에는 시간이 걸릴 수 있습니다.)

### 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2227` | `22` | `ssh root@<서버_IP> -p 2227` | `root` | `!@#gds$%^` |
| Apache | `8084` | `80` | `http://<서버_IP>:8084` | - | - |
| MySQL | `33061`| `3306` | `<서버_IP>` | `root` | `!@#gds$%^` |

---

## 환경 2: `docker-compose-centos.yml` (변형 환경)

이 환경은 환경 1과 거의 동일하지만, 컨테이너 이름(`docker_jobtp`)과 사용하는 볼륨 이름(`dbdata_jobtp` 등)이 다릅니다.

### 사용 방법

```bash
# 1. 볼륨 생성
docker volume create dbdata_jobtp
docker volume create dbconfig_jobtp
docker volume create apconfig_jobtp

# 2. 빌드 및 시작
docker-compose -f docker-compose-centos.yml up -d --build
```

**참고**: `rebuild_docker.sh` 스크립트는 이 환경의 볼륨 이름(`dbdata_jobtp` 등)을 생성하지만, `docker-compose.yml`(환경 1)을 실행하도록 되어 있어 그대로 사용하면 오류가 발생합니다. 스크립트를 사용하려면 내부의 `docker-compose up -d` 부분을 `docker-compose -f docker-compose-centos.yml up -d`로 수정해야 합니다. 