# 올인원 개발 서버 (Tomcat, MariaDB, SVN)

이 프로젝트는 단일 Docker 컨테이너 내에 Java 웹 개발 및 협업에 필요한 거의 모든 서비스를 통합하여 제공하는 "올인원(All-in-One)" 개발 환경입니다.

## 주요 기능

- **기반 환경**: Ubuntu 20.04
- **웹 애플리케이션 서버(WAS)**: Apache Tomcat 8.5.98 (OpenJDK 8, Maven 포함)
- **데이터베이스**: MariaDB Server
- **버전 관리 시스템**: Subversion (SVN), Apache(http) 및 svnserve(svn) 프로토콜 동시 지원
- **원격 접속**: OpenSSH Server

## 사전 요구사항

- [Docker](https://www.docker.com/get-started)
- [Docker Compose](https://docs.docker.com/compose/install/)

## 사용 방법

### 1. 서비스 시작 및 빌드

아래 스크립트를 실행하여 필요한 모든 Docker 볼륨을 생성하고, 이미지를 빌드한 뒤, 컨테이너를 시작합니다.

```bash
./rebuild_docker.sh
```

이 스크립트는 `dbdata`, `svndata` 등 7개의 Docker 볼륨을 자동으로 생성하고 `docker-compose.yml` 설정에 따라 컨테이너를 백그라운드에서 실행합니다.

### 2. 웹 애플리케이션 배포

WAR 파일을 `wardata` 볼륨에 해당하는 Tomcat의 `webapps` 디렉토리에 복사하여 배포할 수 있습니다.

```bash
# 로컬의 my_app.war 파일을 컨테이너의 웹앱 디렉토리로 복사
docker cp my_app.war docker_all:/usr/local/tomcat/webapps/
```

## 서비스 접속 정보

| 서비스 | 호스트 포트 | 컨테이너 포트 | 주소 / 명령어 | 계정 | 비밀번호 |
|---|---|---|---|---|---|
| SSH | `2226` | `22` | `ssh root@<서버_IP> -p 2226` | `root` | `!@#gds$%^` |
| MariaDB | `33060`| `3306` | `<서버_IP>` | `root` | `fnxmdkagh` |
| Tomcat | `8083` | `8080` | `http://<서버_IP>:8083` | - | - |
| SVN (http) | `8086` | `80` | `http://<서버_IP>:8086/svn/geumdo_repo`| `gds` | `!@#gds$%^` |
| SVN (svn) | `3690` | `3690` | `svn://<서버_IP>/geumdo_repo` | (설정필요) | (설정필요) |
| SecureDB | `9908` | `9908`| (에이전트 연결 포트) | - | - |

**참고**: `svnserve` 프로토콜(`svn://`)을 통한 접속은 별도의 사용자/권한 설정 파일(`svnserve.conf`, `passwd`)을 `svndata` 볼륨에서 구성해야 할 수 있습니다.

## 데이터 영속성 (볼륨)

이 환경은 각 서비스의 데이터와 설정을 보존하기 위해 7개의 Docker 볼륨을 사용합니다.

- `dbdata`: MariaDB 데이터 파일
- `dbconfig`: MariaDB 설정 파일
- `wasconfig`: Tomcat 설정 파일
- `wardata`: Tomcat 웹 애플리케이션 (WAR 파일)
- `svndata`: SVN 저장소 데이터 (`geumdo_repo`)
- `data`: Java 팀 범용 데이터 저장용
- `securedb`: SecureDB 에이전트 데이터 저장용 