# 3D 프린터 슬라이싱 API

이 프로젝트는 [Flask](https://flask.palletsprojects.com/)를 사용하여 구축된 웹 API로, [PrusaSlicer](https://www.prusa3d.com/page/prusaslicer_424/)를 이용해 STL 3D 모델 파일을 G-code로 변환하는 기능을 제공합니다. Prusa MK4 3D 프린터에 최적화된 설정을 포함하고 있습니다.

## 주요 기능

-   **STL to G-code 변환**: `/slice` 엔드포인트를 통해 STL 파일을 G-code로 슬라이싱합니다.
-   **상세한 파라미터 설정**: PrusaSlicer에서 제공하는 거의 모든 슬라이싱 파라미터를 API 요청 시점에 커스터마이징할 수 있습니다.
-   **오류 처리**: 슬라이싱 과정에서 발생할 수 있는 일반적인 오류들을 감지하고, 구체적인 오류 코드와 메시지를 반환합니다.
-   **파일 관리 및 프록시**: 생성된 G-code 파일을 다운로드하고, Prusa 프린터의 웹 인터페이스인 PrusaLink로 요청을 전달하는 프록시 기능을 제공합니다.

## API 엔드포인트

### `POST /slice`

STL 파일을 업로드하고 슬라이싱 옵션을 지정하여 G-code를 생성합니다.

-   **Request Body (`multipart/form-data`):**
    -   `file` (file, optional): 슬라이싱할 `.stl` 파일. 서버에 파일이 이미 존재하는 경우 `orignlFileNm`으로 대체할 수 있습니다.
    -   `orignlFileNm` (string, optional): 서버에 미리 업로드된 파일의 이름.
    -   `...options`: PrusaSlicer에 전달할 키-값 형태의 슬라이싱 옵션들. (자세한 내용은 아래의 '슬라이싱 옵션' 섹션 참조)

-   **Success Response (200 OK):**
    ```json
    {
      "success": true,
      "message": "모델이 성공적으로 슬라이스되었습니다."
    }
    ```

-   **Error Response:**
    -   **파일 관련 오류:**
        -   `100`: 업로드된 파일이 없음.
        -   `200`: `orignlFileNm`으로 지정된 파일이 서버 경로에 없음.
        -   `300`: STL 파일이 아닌 다른 확장자 파일 업로드.
    -   **슬라이싱 오류 (PrusaSlicer):**
        -   `401`: 첫 레이어에 압출이 없는 객체가 존재.
        -   `402`: 객체에 대한 압출이 생성되지 않음.
        -   `403`: 현재 설정으로 모델을 인쇄할 수 없음.
        -   `404`: 지지대(support) 없이 인쇄할 수 없는 객체가 있음.
        -   `405`: 레이어가 감지되지 않음 (STL 파일 복구 필요).
        -   `406`: 현재 설정으로 패드(pad)를 생성할 수 없음.
        -   `407`: 인쇄할 수 없는 객체가 있음 (지지대 설정 조정 필요).
        -   `400`: 그 외의 알 수 없는 슬라이싱 오류.

### `GET /getGCodeFile`

서버에 생성된 G-code 파일을 다운로드합니다.

-   **Query Parameters:**
    -   `fileName` (string, required): 다운로드할 G-code 파일의 이름.

-   **Success Response (200 OK):**
    -   `Content-Type: application/octet-stream`
    -   G-code 파일 데이터 스트림.

### `GET /getPrusaConfig`

서버에 저장된 PrusaSlicer 설정 파일(`fff_option.txt`)의 내용을 반환합니다.

### `ANY /proxy`

PrusaLink 장비로 API 요청을 전달하는 프록시 역할을 합니다. PrusaLink API의 엔드포인트와 파라미터를 그대로 사용합니다.

## 설치 및 실행

### 요구사항

-   Python 3.x
-   PrusaSlicer
-   Flask 및 기타 Python 패키지

### 설정

1.  **소스 코드 클론:**
    ```bash
    git clone <repository-url>
    cd <repository-directory>
    ```

2.  **환경 변수 설정:**
    프로젝트 루트에 `.env` 파일을 생성하고 아래 내용을 채웁니다. 이 프로젝트는 하드코딩된 경로를 사용하므로, 환경에 맞게 소스 코드(`app.py`) 수정이 필요할 수 있습니다.
    ```
    # .env
    PRUSA_LINK_URL=http://<your-prusa-link-ip>
    PRUSA_LINK_API_KEY=<your-prusa-link-api-key>
    ```

3.  **Python 의존성 설치:**
    가상 환경을 생성하고 필요한 패키지를 설치합니다.
    ```bash
    python -m venv venv
    source venv/bin/activate
    pip install Flask Flask-Cors python-dotenv requests
    ```
    (프로젝트에 `requirements.txt` 파일을 생성하여 관리하는 것을 권장합니다.)

4.  **PrusaSlicer 설치:**
    PrusaSlicer를 시스템에 설치해야 합니다. `app.py`에서는 실행 경로가 `/usr/bin/PrusaSlicer`로 하드코딩되어 있으므로, 실제 설치 경로가 다를 경우 코드를 수정해야 합니다.

5.  **애플리케이션 실행:**
    ```bash
    flask run
    ```

## 슬라이싱 옵션

API를 통해 PrusaSlicer의 다양한 설정을 제어할 수 있습니다. `slicer_test.py` 파일에 거의 모든 사용 가능한 옵션이 정의되어 있습니다.

<details>
<summary><b>전체 옵션 목록 보기 (예시)</b></summary>

```python
options = {
    'layer-height': '0.1',
    'first-layer-height': '0.2',
    'perimeters': '3',
    'top-solid-layers': '8',
    'bottom-solid-layers': '6',
    'fill-density': '15%',
    'fill-pattern': 'grid',
    'support-material': '',
    'support-material-auto': '',
    # ... and many more options
}
```
</details>

## 커스텀 G-code

이 API는 Prusa MK4 프린터에 최적화된 시작(`start_gcode`) 및 종료(`end_gcode`) G-code를 슬라이싱 결과물에 자동으로 삽입합니다. 이 코드는 `app.py` 내에 변수로 정의되어 있으며, 필요에 따라 수정할 수 있습니다.