# 3D 프린팅 관리 및 웹 슬라이싱 솔루션

본 프로젝트는 Docker 기반으로 패키징된 복합 3D 프린팅 관리 솔루션입니다. Nextcloud를 이용한 파일 관리, 웹 기반 원격 슬라이싱, 프린터 제어 기능을 통합하여 제공합니다.

## 기술 아키텍처

시스템은 모든 서비스가 단일 Docker 컨테이너에서 동작하는 올인원(All-in-one) 방식으로 설계되었습니다.

-   **`Dockerfile`**: `ubuntu:20.04` 베이스 이미지 위에 다음과 같은 다양한 소프트웨어를 설치하여 복잡한 실행 환경을 구성합니다.
    -   **서버 소프트웨어**: Nginx, PHP 7.4-FPM, MariaDB, OpenSSH Server, OpenJDK 17
    -   **핵심 애플리케이션**:
        -   **Nextcloud 23.0.12**: 소스 코드를 직접 다운로드하여 설치. 파일 저장 및 관리의 중심 역할을 합니다.
        -   **PrusaSlicer**: AppImage 형태의 3D 프린터 슬라이서를 `/usr/bin`에 설치하여 커맨드라인으로 실행할 수 있도록 합니다.
        -   **Python 3 / Flask**: 슬라이싱 API 및 프린터 제어 프록시를 위한 웹 애플리케이션을 실행합니다.

-   **`docker-compose.yml`**:
    -   **단일 서비스 `os`**: 모든 기능이 포함된 `Dockerfile`을 빌드하여 `docker_3dp`라는 이름의 컨테이너를 생성합니다.
    -   **포트 매핑**: Nextcloud(80), SSH(2212), Flask API(3000), MariaDB(3306), 다수의 임베디드 Tomcat(8080, 8090 등) 포트를 외부에 노출시켜 각 서비스에 접근할 수 있도록 합니다.
    -   **볼륨 및 권한**:
        -   호스트의 `./printer` 폴더를 컨테이너의 Flask 앱 경로에, `./sites-available`을 Nginx 설정 경로에 마운트하여 외부에서 코드를 수정하고 관리할 수 있게 합니다.
        -   AppImage 실행에 필요한 FUSE(Filesystem in Userspace)를 사용하기 위해 `/dev/fuse` 장치를 마운트하고 `SYS_ADMIN` 권한과 `apparmor:unconfined` 설정을 부여합니다. 이는 컨테이너에 높은 수준의 권한을 부여하는 중요한 설정입니다.

### 워크플로우

1.  **서비스 시작 (`start_service.sh`)**: 컨테이너가 시작되면 이 스크립트가 실행되어 SSH, MariaDB, PHP-FPM, Nginx 등 내부의 모든 데몬을 순차적으로 구동합니다. 또한, Flask 웹 애플리케이션을 실행하여 API 서비스 준비를 마칩니다.

2.  **파일 관리 (Nextcloud)**: 사용자는 웹 브라우저를 통해 `http://<host-ip>`로 접속하여 Nextcloud에 3D 모델 파일(.stl)을 업로드하고 관리합니다.

3.  **웹 슬라이싱 (Flask API)**:
    -   외부 클라이언트는 `http://<host-ip>:3000/slice` 엔드포인트로 HTTP POST 요청을 보냅니다.
    -   요청에는 슬라이싱할 STL 파일의 경로(Nextcloud 내)와 세부적인 프린팅 옵션(레이어 높이, 채우기 밀도 등)이 포함됩니다.
    -   Flask 앱은 `subprocess` 모듈을 사용하여 `PrusaSlicer` 커맨드라인을 실행하고, 전달받은 옵션을 적용하여 STL 파일을 G-code로 변환합니다.
    -   슬라이싱 과정에서 발생하는 특정 오류를 감지하고, 이를 사용자 친화적인 한글 메시지와 코드로 변환하여 응답하는 상세한 예외 처리 기능이 포함되어 있습니다.

4.  **프린터 제어 (PrusaLink Proxy)**:
    -   `http://<host-ip>:3000/proxy` 엔드포인트는 PrusaLink API를 중계하는 프록시 역할을 수행합니다. 이를 통해 실제 3D 프린터의 상태 조회, 출력 시작/중지 등의 원격 제어가 가능합니다.

## 기술 스택

-   **오케스트레이션**: Docker, Docker Compose
-   **웹 서버**: Nginx
-   **애플리케이션 서버**: PHP 7.4-FPM, Flask (Python)
-   **데이터베이스**: MariaDB
-   **파일 공유 플랫폼**: Nextcloud 23.0.12
-   **3D 슬라이서**: PrusaSlicer (AppImage)
-   **주요 언어**: Python, Bash, PHP

## 실행 방법

### 사전 요구사항

-   Docker 및 Docker Compose
-   `3dp_dbconfig`, `3dp_dbdata` 라는 이름의 Docker 외부 볼륨이 사전에 생성되어 있어야 합니다.
    ```bash
    docker volume create 3dp_dbconfig
    docker volume create 3dp_dbdata
    ```

### 실행

1.  **Docker 이미지 빌드 및 컨테이너 실행**:
    ```bash
    # (선택) 재빌드 및 실행 스크립트
    ./rebuild_docker.sh

    # 또는 docker-compose 직접 실행
    docker-compose up --build -d
    ```

2.  **애플리케이션 접근**:
    -   **Nextcloud**: `http://<서버_IP>`
    -   **슬라이싱 API**: `http://<서버_IP>:3000`
    -   **SSH**: `ssh root@<서버_IP> -p 2212` (초기 비밀번호는 Dockerfile 확인 필요)

### 중지

```bash
docker-compose down
``` 