# AWS/GCP/Azure 무료 티어 활용 AI 실습 환경 구축 가이드

## 개요
이 문서는 주요 클라우드 서비스인 AWS, Google Cloud Platform(GCP), Microsoft Azure의 무료 티어 서비스를 활용하여 AI 학습 및 실습 환경을 구축하는 방법을 안내합니다. 각 클라우드 서비스별로 무료로 사용할 수 있는 리소스와 설정 방법, 그리고 주의사항을 포함하고 있습니다.

## 목차
1. [클라우드 서비스 선택 가이드](#1-클라우드-서비스-선택-가이드)
2. [AWS 무료 티어 활용 가이드](#2-aws-무료-티어-활용-가이드)
3. [GCP 무료 티어 활용 가이드](#3-gcp-무료-티어-활용-가이드)
4. [Azure 무료 티어 활용 가이드](#4-azure-무료-티어-활용-가이드)
5. [공통 Docker 배포 방법](#5-공통-docker-배포-방법)
6. [비용 관리 및 모니터링](#6-비용-관리-및-모니터링)

## 1. 클라우드 서비스 선택 가이드

| 고려사항 | AWS | GCP | Azure |
|---------|-----|-----|-------|
| **초기 크레딧** | 1년간 무료 티어 | $300 크레딧 (90일) | $200 크레딧 (30일) |
| **ML 특화 서비스** | SageMaker | Vertex AI | Azure ML |
| **GPU 가용성** | 제한적 (무료 티어에 없음) | Colab 무료 (제한적) | 제한적 (무료 티어에 없음) |
| **사용 난이도** | 복잡함 | 중간 | 사용자 친화적 |
| **문서화 수준** | 매우 상세함 | 상세함 | 매우 상세함 |
| **교육용 적합성** | 높음 (AWS Academy) | 높음 (Qwiklabs) | 높음 (MS Learn) |

### 추천 조합
- **초보자**: Azure 또는 GCP
- **중급자**: 모든 서비스 적합
- **고급자**: AWS (특히 MLOps 관점)
- **무료 GPU 필요시**: GCP (Colab)

## 2. AWS 무료 티어 활용 가이드

### AWS 무료 티어 개요
AWS 무료 티어는 12개월 무료, 항상 무료, 단기 무료 평가판의 세 가지 유형으로 제공됩니다.

### AI/ML 학습에 유용한 AWS 무료 서비스
1. **EC2** (12개월 무료)
   - t2.micro 또는 t3.micro 인스턴스 750시간/월
   - Python, Jupyter, TensorFlow 등 설치 가능

2. **S3** (12개월 무료)
   - 5GB 스토리지, 데이터셋 저장에 활용

3. **Amazon SageMaker** (항상 무료)
   - SageMaker Studio Lab - 무료 GPU 제한적 제공

4. **AWS Lambda** (항상 무료)
   - 매월 100만 건의 요청, 간단한 ML 추론 API 구현 가능

### AWS 환경 설정 가이드
1. **계정 생성**
   ```bash
   # AWS 계정 생성: https://aws.amazon.com
   # 신용카드 등록 필요 (청구되지 않음)
   ```

2. **EC2 인스턴스 시작**
   ```bash
   # AWS 콘솔 > EC2 > 인스턴스 시작
   # Amazon Linux 2 선택
   # t2.micro 또는 t3.micro 선택 (무료 티어 적격)
   ```

3. **Docker로 AI 개발환경 설정**
   ```bash
   # EC2 접속 후
   sudo yum update -y
   sudo amazon-linux-extras install docker -y
   sudo systemctl start docker
   sudo systemctl enable docker
   sudo usermod -a -G docker ec2-user

   # 재로그인 후
   # 도커 컨테이너 실행 (JupyterLab)
   docker run -d -p 8888:8888 -v $PWD:/home/jovyan/work jupyter/datascience-notebook
   ```

### 무료 티어 한도 모니터링
- AWS Billing 대시보드 활용
- 비용 알림 설정: CloudWatch > 결제 알림

## 3. GCP 무료 티어 활용 가이드

### GCP 무료 티어 개요
GCP는 $300 무료 크레딧 (90일)과 일부 항상 무료 제품을 제공합니다.

### AI/ML 학습에 유용한 GCP 무료 서비스
1. **Google Colab** (별도 계정)
   - 무료 GPU/TPU 액세스 (세션 시간 제한)
   - 노트북 형태로 개발 가능

2. **Compute Engine** (무료 크레딧 사용)
   - e2-micro 인스턴스 (vCPU 2개, 1GB 메모리)

3. **Cloud Storage** (항상 무료)
   - 5GB 스토리지

4. **BigQuery** (항상 무료)
   - 매월 1TB 쿼리 처리, 데이터 분석 학습에 유용

### GCP 환경 설정 가이드
1. **계정 생성**
   ```bash
   # GCP 계정 생성: https://cloud.google.com
   # 신용카드 등록 필요 (청구되지 않음)
   ```

2. **Compute Engine VM 인스턴스 생성**
   ```bash
   # GCP 콘솔 > Compute Engine > VM 인스턴스
   # e2-micro 선택
   # Ubuntu 20.04 LTS 선택
   ```

3. **Docker로 AI 개발환경 설정**
   ```bash
   # VM 접속 후
   sudo apt-get update
   sudo apt-get install -y docker.io
   sudo systemctl start docker
   sudo systemctl enable docker
   sudo usermod -a -G docker $USER

   # 재로그인 후
   # 도커 컨테이너 실행 (JupyterLab)
   docker run -d -p 8888:8888 -v $PWD:/home/jovyan/work jupyter/datascience-notebook
   ```

### Google Colab 활용
1. https://colab.research.google.com 접속
2. 새 노트북 생성
3. 런타임 > 런타임 유형 변경 > GPU 또는 TPU 선택

## 4. Azure 무료 티어 활용 가이드

### Azure 무료 티어 개요
Azure는 $200 무료 크레딧 (30일)과 40개 이상의 항상 무료 서비스를 제공합니다.

### AI/ML 학습에 유용한 Azure 무료 서비스
1. **Azure Virtual Machines** (무료 크레딧 사용)
   - B1s 인스턴스 (1 vCPU, 1GB 메모리)

2. **Azure Storage** (항상 무료)
   - 5GB 스토리지

3. **Azure Machine Learning** (무료 크레딧 사용)
   - 워크스페이스 생성 및 간단한 모델 학습

4. **Azure Cognitive Services** (항상 무료)
   - 일정량 내 API 호출 무료

### Azure 환경 설정 가이드
1. **계정 생성**
   ```bash
   # Azure 계정 생성: https://azure.microsoft.com
   # 신용카드 등록 필요 (청구되지 않음)
   ```

2. **가상머신 생성**
   ```bash
   # Azure 포털 > 가상 머신 > 추가
   # B1s 또는 B1ls 선택
   # Ubuntu 20.04 LTS 선택
   ```

3. **Docker로 AI 개발환경 설정**
   ```bash
   # VM 접속 후
   sudo apt-get update
   sudo apt-get install -y docker.io
   sudo systemctl start docker
   sudo systemctl enable docker
   sudo usermod -a -G docker $USER

   # 재로그인 후
   # 도커 컨테이너 실행 (JupyterLab)
   docker run -d -p 8888:8888 -v $PWD:/home/jovyan/work jupyter/datascience-notebook
   ```

## 5. 공통 Docker 배포 방법

AI 강의 도커 환경을 각 클라우드 서비스에 일관되게 배포하기 위한 방법입니다.

### 준비 사항
1. 클라우드 인스턴스 접속 권한
2. Docker 설치 완료
3. `docker-compose.yml` 파일 준비

### 배포 단계
1. **프로젝트 클론**
   ```bash
   git clone https://github.com/your-org/ai-course.git
   cd ai-course
   ```

2. **도커 컴포즈 실행**
   ```bash
   # CPU 버전 (무료 티어에 적합)
   docker-compose -f docker-compose.yml up -d

   # GPU 버전 (유료 인스턴스에서만)
   docker-compose -f docker-compose.gpu.yml up -d
   ```

3. **포트포워딩 설정**
   - 클라우드 콘솔에서 인바운드 포트 허용 (8888, 8000, 5000)

4. **접속 방법**
   - 브라우저에서 `http://<클라우드_인스턴스_IP>:8888`
   - 토큰: `ai_course_token`

## 6. 비용 관리 및 모니터링

### AWS 비용 관리
- AWS Budgets 설정
- AWS Cost Explorer 활용
- 미사용 리소스 정리 (EBS 볼륨, 탄력적 IP 등)

### GCP 비용 관리
- 결제 알림 설정
- 결제 내보내기 설정
- 할당량 한도 설정

### Azure 비용 관리
- Azure Cost Management 활용
- 예산 알림 설정
- 미사용 리소스 자동 종료 설정

## 결론

각 클라우드 서비스의 무료 티어는 AI 학습을 시작하기에 충분한 자원을 제공합니다. 실습 목적에 가장 맞는 서비스를 선택하고, 비용 모니터링을 통해 예상치 못한 청구가 발생하지 않도록 주의하세요. 더 높은 성능이 필요한 딥러닝 작업의 경우 GCP Colab이나 유료 서비스를 고려하는 것이 좋습니다. 