# Docker 프로젝트 모음

이 디렉토리는 다양한 목적의 Docker 기반 애플리케이션 및 서비스 환경을 포함하고 있습니다. 각 하위 디렉토리는 독립적인 프로젝트이며, 자체 `README.md` 파일에 더 자세한 설명이 있습니다.

## 🚀 프로젝트 목록

| 프로젝트 디렉토리 | 설명 | 주요 기술 | 실행 방법 |
| --- | --- | --- | --- |
| **`docker_all`** | Java 웹 개발 및 협업에 필요한 모든 서비스(Tomcat, MariaDB, SVN)를 통합한 올인원 개발 서버입니다. | `Tomcat`, `MariaDB`, `SVN`, `Java 8` | `./rebuild_docker.sh` |
| **`docker_centos`** | CentOS 6 기반의 레거시 APM(Apache, PHP, MySQL) 스택을 구축하고, 대용량 SQL 덤프를 자동으로 복원합니다. | `CentOS 6`, `Apache`, `MySQL`, `PHP` | `./rebuild_docker.sh` 또는 수동 |
| **`docker_centos_desktop`** | CentOS 6.10 기반의 웹 서버 환경으로, 소스 컴파일을 통해 최신 빌드 도구(GCC 8)를 설치합니다. | `CentOS 6.10`, `Apache`, `MySQL`, `PHP` | `./rebuild_docker.sh` |
| **`docker_crowling`** | 외부 `geumdo_analysis` 디렉토리의 Python 크롤링/분석 애플리케이션을 FastAPI 서버로 실행합니다. | `FastAPI`, `Python` | `./rebuild.sh` 및 수동 설정 |
| **`docker_db`** | MariaDB 서버 환경을 구축하며, 컨테이너 시작 시 원격 접속 가능한 `root` 계정을 자동으로 설정합니다. | `MariaDB`, `Ubuntu 20.04` | `./rebuild.sh` |
| **`docker_db_new`** | MariaDB 서버 환경으로, `make_root_remote_host.sh` 스크립트를 통해 수동으로 원격 접속을 설정해야 합니다. | `MariaDB`, `Ubuntu 20.04` | `./rebuild.sh` 및 수동 설정 |
| **`docker_fastapi`** | 스마트스토어, 쿠팡 상품 정보 및 리뷰를 수집하고 AI 감성 분석을 수행하는 크롤링 시스템입니다. | `FastAPI`, `Selenium`, `TensorFlow` | `docker-compose up -d` |
| **`docker_fastapi_new`** | AI 감성 분석 및 크롤링 시스템으로, Selenium, Mecab, TensorFlow 등을 포함합니다. | `FastAPI`, `Selenium`, `Mecab`, `Java 8` | `./rebuild.sh` |
| **`docker_flask_proxy`** | 특정 URL로 요청을 전달하는 간단한 HTTPS 리버스 프록시 서버입니다. | `Flask`, `Python` | `./rebuild_docker.sh` |
| **`docker_gitlab`** | 공식 이미지를 사용하여 GitLab CE(Community Edition) 서버를 배포합니다. | `GitLab CE` | `docker-compose up -d` |
| **`docker_java`** | Java 웹 개발을 위한 완전한 환경(Tomcat, MariaDB, SSH)을 제공합니다. | `Tomcat`, `MariaDB`, `Java 8` | `./rebuild_docker.sh` |
| **`docker_jenkins`** | Jenkins CI/CD 자동화 서버를 구축하며, 데이터는 호스트에 영속적으로 저장됩니다. | `Jenkins`, `OpenJDK 8`, `MariaDB` | `./rebuild.sh` |
| **`docker_jupyter`** | GPU를 지원하는 Jupyter Lab 실행 환경으로, PyTorch가 사전 설치되어 있습니다. | `Jupyter Lab`, `PyTorch`, `GPU` | `docker-compose up -d` |
| **`docker_jupyter_gpu_docker`** | TensorFlow와 PyTorch를 모두 지원하는 범용 GPU 딥러닝 연구 환경입니다. | `Jupyter Lab`, `TensorFlow`, `PyTorch`, `CUDA` | `./rebuild_with_fix.sh` |
| **`docker_mailserver`** | Poste.io를 사용하여 SMTP, IMAP, 웹메일 등 모든 기능을 갖춘 올인원 메일 서버를 구축합니다. | `Poste.io` | `./rebuild.sh` |
| **`docker_metaverse`** | PHP와 Node.js 기반의 복합 웹 애플리케이션('노담') 서버 환경을 패키징합니다. | `PHP`, `Node.js`, `MySQL`, `Nginx` | `./rebuild_docker.sh` |
| **`docker_nginx_proxy`** | Nginx 기반 리버스 프록시 서버로, Let's Encrypt `certbot`을 통해 SSL/TLS 인증서를 관리합니다. | `Nginx`, `Certbot`, `OpenSSL` | `./rebuild_docker.sh` |
| **`docker_open_webui`** | Ollama, OpenAI 등 다양한 LLM Runner를 지원하는 사용자 친화적인 웹 UI입니다. | `Docker`, `Ollama`, `Python` | `docker run ...` |
| **`docker_posivibes`** | 'Posivibes'라는 Java 웹 애플리케이션을 실행하기 위한 Tomcat 8.5 기반의 WAS 환경입니다. | `Tomcat 8.5`, `Java 8` | `./rebuild_docker.sh` |
| **`docker_prusa_exporter`** | Prusa 3D 프린터의 상태 정보를 Prometheus로 익스포트하여 Grafana로 모니터링합니다. | `Prometheus`, `Grafana`, `Go` | `docker compose up` |
| **`docker_registry`** | Docker 이미지를 저장하고 관리할 수 있는 사설 레지스트리(Web UI 포함)를 구축합니다. | `Docker Registry`, `Web UI` | `docker-compose up -d` |
| **`docker_securedb`** | 'DBSEC' 데이터베이스 보안 솔루션을 실행하기 위한 환경을 제공합니다. | `OpenJDK 11`, `Ubuntu 20.04` | `./rebuild_docker.sh` |
| **`docker_ubuntu_ssh`** | `sudo` 권한을 가진 일반 사용자가 설정된 기본 Ubuntu 22.04 + SSH 서버 환경입니다. | `Ubuntu 22.04`, `SSH` | `./rebuild_docker.sh` |
| **`docker_vnexa_api`** | 호출 시 마크다운 텍스트를 무작위로 반환하는 간단한 Flask API 서버 예제입니다. | `Flask`, `Python`, `Ubuntu 20.04` | `./rebuild_docker.sh` |
| **`docker_was`** | `sabg.war`라는 특정 Java 웹 애플리케이션을 배포하기 위한 Tomcat 8.5 기반의 WAS 환경입니다. | `Tomcat 8.5`, `Java 8` | `./rebuild_docker.sh` |
| **`docker_was_upgrade`** | OpenJDK 11과 Tomcat 9를 기반으로 하는 업그레이드된 Java WAS 환경입니다. (복제본) | `Tomcat 9`, `Java 11` | `./rebuild_docker.sh` |
| **`docker_was_upgrade_http`** | OpenJDK 11과 Tomcat 9를 기반으로 하는 업그레이드된 Java WAS 환경입니다. | `Tomcat 9`, `Java 11` | `./rebuild_docker.sh` |
| **`docker-windows-vm`** | Docker 컨테이너 내부에 KVM을 설치하고, Vagrant를 사용해 Windows 10 VM을 구동하는 복합 가상화 환경입니다. | `KVM`, `Vagrant`, `Windows 10`, `RDP` | `docker-compose up -d` |
| **`examples`** | Spring Boot 등 내장 WAS를 사용하는 Java Maven 프로젝트를 Docker화하는 예제/템플릿입니다. | `Java`, `Maven`, `Spring Boot` | `./rebuild_docker.sh` |
| **`geumdo-rag-chat-bot`** | 사내 GitLab 코드에 대해 자연어 질의를 할 수 있는 RAG 기반 챗봇 시스템입니다. | `RAG`, `LangChain`, `FastAPI`, `Streamlit` | `docker-compose up --build -d` |
| **`gpu_cooling_monitor`** | TIG 스택(InfluxDB, Grafana)을 활용하여 서버의 GPU 및 시스템 냉각 상태를 실시간으로 모니터링합니다. | `InfluxDB`, `Grafana`, `Python`, `Slack` | `docker-compose up -d` |
| **`jupyter_geumdo_lab`** | Kubernetes(K8s) 기반의 다중 사용자 JupyterHub 서비스로, Google OAuth 인증과 동적 GPU/CPU 서버 생성을 지원합니다. | `Kubernetes`, `JupyterHub`, `NFS`, `OAuth` | `helm upgrade ...` |
| **`docker_3dp`** | Nextcloud 파일 관리, 웹 기반 원격 슬라이싱(PrusaSlicer), 프린터 제어 기능을 통합한 3D 프린팅 솔루션입니다. | `Nextcloud`, `PrusaSlicer`, `Flask`, `PHP` | `./rebuild_docker.sh` |
---

보다 자세한 내용은 각 디렉토리의 `README.md` 파일을 참고하십시오. 